/*
 * Decompiled with CFR 0.152.
 */
package yeelp.lifescroll.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import yeelp.lifescroll.capability.IScrollSpawn;
import yeelp.lifescroll.capability.ScrollSpawn;
import yeelp.lifescroll.handlers.CapabilityHandler;
import yeelp.lifescroll.handlers.SpawnHandler;

public class ItemSpawnScroll
extends Item {
    private static final ITextComponent usable = new TextComponentTranslation("tooltips.lifescroll.spawnscroll.usable", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN));
    private static final ITextComponent unusable = new TextComponentTranslation("tooltips.lifescroll.spawnscroll.unusable", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    private static final ITextComponent fail = new TextComponentTranslation("messages.lifescroll.spawnscroll.fail", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));

    public ItemSpawnScroll() {
        this.setRegistryName("spawnscroll");
        this.func_77655_b("lifescroll.spawnscroll");
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (world == null) {
            return;
        }
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            tooltip.add(usable.func_150254_d());
        } else {
            tooltip.add(unusable.func_150254_d());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.field_71093_bK == 0) {
                SpawnHandler.registerScrollUse(player);
                BlockPos pos = player.func_180425_c();
                player.func_180473_a(pos, true);
                IScrollSpawn spawn = ScrollSpawn.get(player);
                spawn.setSpawn(pos);
                spawn.setStatus(true);
                CapabilityHandler.syncSpawn(player);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190920_e(Math.max(0, stack.func_190916_E() - 1));
                }
                player.func_145747_a(new TextComponentTranslation("messages.lifescroll.spawnscroll.success", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            player.func_145747_a(fail);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }
}

