/*
 * Decompiled with CFR 0.152.
 */
package yeelp.lifescroll.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import yeelp.lifescroll.capability.IScrollSpawn;
import yeelp.lifescroll.capability.ScrollSpawn;
import yeelp.lifescroll.handlers.AbstractHandler;
import yeelp.lifescroll.handlers.CapabilityHandler;

public final class SpawnHandler
extends AbstractHandler {
    private static HashSet<UUID> scrollUsed = new HashSet();
    private static HashMap<UUID, BlockPos> cachedSpawn = new HashMap();

    public static void registerScrollUse(EntityPlayer player) {
        scrollUsed.add(player.func_110124_au());
    }

    @SubscribeEvent
    public void onSetSpawn(PlayerSetSpawnEvent evt) {
        IScrollSpawn spawn;
        EntityPlayer player = evt.getEntityPlayer();
        if (SpawnHandler.shouldKeepScrollEnabled(player, spawn = ScrollSpawn.get(player), evt.getNewSpawn())) {
            return;
        }
        spawn.setStatus(false);
        CapabilityHandler.syncSpawn(player);
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent evt) {
        if (evt.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)evt.getEntityLiving();
            IScrollSpawn spawn = ScrollSpawn.get(player);
            Optional<BlockPos> newPos = IScrollSpawn.getScrollSpawnPos(player);
            if (newPos.isPresent()) {
                cachedSpawn.put(player.func_110124_au(), newPos.get());
                player.func_180473_a(newPos.get(), true);
            }
        }
    }

    @SubscribeEvent
    public void onJoin(EntityJoinWorldEvent evt) {
        if (evt.getEntity() instanceof EntityPlayer) {
            Optional<BlockPos> pos;
            EntityPlayer player = (EntityPlayer)evt.getEntity();
            IScrollSpawn spawn = ScrollSpawn.get(player);
            if (!cachedSpawn.containsKey(player.func_110124_au()) && (pos = IScrollSpawn.getScrollSpawnPos(player)).isPresent()) {
                cachedSpawn.put(player.func_110124_au(), pos.get());
            }
        }
    }

    private static boolean shouldKeepScrollEnabled(EntityPlayer player, IScrollSpawn scroll, BlockPos spawn) {
        if (!player.field_70170_p.field_72995_K) {
            return scrollUsed.remove(player.func_110124_au()) || player.func_110143_aJ() <= 0.0f || scroll.enabled() && spawn.equals((Object)cachedSpawn.get(player.func_110124_au()));
        }
        return false;
    }
}

