/*
 * Decompiled with CFR 0.152.
 */
package yeelp.lifescroll.handlers;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import yeelp.lifescroll.capability.IScrollSpawn;
import yeelp.lifescroll.capability.ScrollSpawn;
import yeelp.lifescroll.handlers.AbstractHandler;
import yeelp.lifescroll.handlers.PacketHandler;
import yeelp.lifescroll.network.SpawnMessage;
import yeelp.lifescroll.util.InventoryUtil;

public class CapabilityHandler
extends AbstractHandler {
    @SubscribeEvent
    public void onAddCaps(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof EntityPlayer) {
            evt.addCapability(new ResourceLocation("lifescroll", "scrollspawn"), (ICapabilityProvider)new ScrollSpawn());
        }
    }

    @SubscribeEvent
    public void onDeath(PlayerEvent.Clone evt) {
        EntityPlayer oldPlayer = evt.getOriginal();
        EntityPlayer newPlayer = evt.getEntityPlayer();
        IScrollSpawn oldSpawn = ScrollSpawn.get(oldPlayer);
        IScrollSpawn newSpawn = ScrollSpawn.get(newPlayer);
        newSpawn.deserializeNBT(oldSpawn.serializeNBT());
        CapabilityHandler.syncSpawn(newPlayer);
        if (evt.isWasDeath()) {
            if (newPlayer.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                return;
            }
            if (newPlayer instanceof FakePlayer) {
                return;
            }
            CapabilityHandler.addScrolls(newPlayer, (NonNullList<ItemStack>)oldPlayer.field_71071_by.field_70462_a, false);
            CapabilityHandler.addScrolls(newPlayer, (NonNullList<ItemStack>)oldPlayer.field_71071_by.field_184439_c, true);
        }
    }

    public static void syncSpawn(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendTo((IMessage)new SpawnMessage(ScrollSpawn.get(player)), (EntityPlayerMP)player);
        }
    }

    private static void addScrolls(EntityPlayer player, NonNullList<ItemStack> inv, boolean offHand) {
        for (Tuple<Integer, ItemStack> t : InventoryUtil.getScrollsFromInventory(inv)) {
            InventoryUtil.addToInventory(player, (ItemStack)t.func_76340_b(), (Integer)t.func_76341_a(), offHand);
        }
    }
}

