/*
 * Decompiled with CFR 0.152.
 */
package yeelp.lifescroll.capability;

import java.util.HashSet;
import java.util.concurrent.Callable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import yeelp.lifescroll.capability.IScrollSpawn;

public class ScrollSpawn
implements IScrollSpawn {
    private BlockPos pos;
    private boolean status;
    @CapabilityInject(value=IScrollSpawn.class)
    public static Capability<IScrollSpawn> cap = null;

    public static IScrollSpawn get(EntityPlayer player) {
        return (IScrollSpawn)player.getCapability(cap, null);
    }

    public ScrollSpawn() {
        this(0, 0, 0);
    }

    public ScrollSpawn(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
        this.status = false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == cap;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == cap ? cap.cast((Object)this) : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("pos", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        tag.func_74757_a("status", this.status);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int[] pos = nbt.func_74759_k("pos");
        this.pos = new BlockPos(pos[0], pos[1], pos[2]);
        this.status = nbt.func_74767_n("status");
    }

    @Override
    public BlockPos getSpawnLocation(World world, int tries) {
        HashSet checked = new HashSet();
        int x = this.pos.func_177958_n();
        int y = this.pos.func_177956_o();
        int z = this.pos.func_177952_p();
        for (int i = 0; i <= tries; ++i) {
            Point p = ScrollSpawn.spiral(i);
            for (int l = 0; l <= 6; l += 3) {
                int yPos = (int)((float)y + Math.signum(l * (l - 4)));
                BlockPos blockpos = new BlockPos(x + p.getX(), yPos, z + p.getZ());
                if (!ScrollSpawn.hasRoomForPlayer(world, blockpos)) continue;
                return blockpos;
            }
        }
        return null;
    }

    @Override
    public BlockPos getExactPos() {
        return this.pos;
    }

    @Override
    public void setSpawn(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public boolean enabled() {
        return this.status;
    }

    @Override
    public void setStatus(boolean status) {
        this.status = status;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IScrollSpawn.class, (Capability.IStorage)new SpawnStorage(), (Callable)new SpawnFactory());
    }

    private static boolean hasRoomForPlayer(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP) && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    private static Point spiral(int n) {
        int k = (int)Math.ceil((Math.sqrt(++n) - 1.0) / 2.0);
        int t = 2 * k + 1;
        int m = t * t;
        if (n >= m - --t) {
            return new Point(k - (m - n), -k);
        }
        if (n >= (m -= t) - t) {
            return new Point(-k, -k + (m - n));
        }
        if (n >= (m -= t) - t) {
            return new Point(-k + (m - n), k);
        }
        return new Point(k, k - (m - n - t));
    }

    private static class Point
    extends Tuple<Integer, Integer> {
        public Point(int aIn, int bIn) {
            super((Object)aIn, (Object)bIn);
        }

        public int getX() {
            return (Integer)super.func_76341_a();
        }

        public int getZ() {
            return (Integer)super.func_76340_b();
        }
    }

    private static class SpawnFactory
    implements Callable<IScrollSpawn> {
        private SpawnFactory() {
        }

        @Override
        public IScrollSpawn call() throws Exception {
            return new ScrollSpawn();
        }
    }

    private static class SpawnStorage
    implements Capability.IStorage<IScrollSpawn> {
        private SpawnStorage() {
        }

        public NBTBase writeNBT(Capability<IScrollSpawn> capability, IScrollSpawn instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<IScrollSpawn> capability, IScrollSpawn instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTBase)((NBTTagCompound)nbt));
        }
    }
}

