/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.api.ClientToServerPacket;
import hohserg.elegant.networking.api.IByteBufSerializable;
import hohserg.elegant.networking.api.ServerToClientPacket;
import hohserg.elegant.networking.impl.Network;
import hohserg.elegant.networking.impl.Registry;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class ForgeNetworkImpl
implements Network<UniversalPacket> {
    private Map<String, SimpleNetworkWrapper> channels = new HashMap<String, SimpleNetworkWrapper>();

    @Override
    public void sendToPlayer(ServerToClientPacket packet, EntityPlayerMP player) {
        this.checkSendingSide(packet);
        this.getChannel(packet).sendTo((IMessage)this.preparePacket(packet), player);
    }

    @Override
    public void sendToClients(ServerToClientPacket packet) {
        this.checkSendingSide(packet);
        this.getChannel(packet).sendToAll((IMessage)this.preparePacket(packet));
    }

    @Override
    public void sendPacketToAllAround(ServerToClientPacket packet, World world, double x, double y, double z, double range) {
        this.checkSendingSide(packet);
        this.getChannel(packet).sendToAllAround((IMessage)this.preparePacket(packet), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, range));
    }

    @Override
    public void sendToDimension(ServerToClientPacket packet, World world) {
        this.checkSendingSide(packet);
        this.getChannel(packet).sendToDimension((IMessage)this.preparePacket(packet), world.field_73011_w.getDimension());
    }

    @Override
    public void sendToChunk(ServerToClientPacket packet, World world, int chunkX, int chunkZ) {
        this.checkSendingSide(packet);
        SimpleNetworkWrapper channel = this.getChannel(packet);
        ServerToClientUniversalPacket message = this.preparePacket(packet);
        PlayerChunkMapEntry playerInstance = ((WorldServer)world).func_184164_w().func_187301_b(chunkX, chunkZ);
        if (playerInstance != null) {
            for (EntityPlayerMP player : playerInstance.getWatchingPlayers()) {
                channel.sendTo((IMessage)message, player);
            }
        }
    }

    @Override
    public void sendToServer(ClientToServerPacket packet) {
        this.checkSendingSide(packet);
        this.getChannel(packet).sendToServer((IMessage)this.preparePacket(packet));
    }

    private SimpleNetworkWrapper getChannel(IByteBufSerializable packet) {
        return this.channels.get(Registry.getChannelForPacket(packet.getClass().getName()));
    }

    private ServerToClientUniversalPacket preparePacket(ServerToClientPacket packet) {
        String channel = Registry.getChannelForPacket(packet.getClass().getName());
        int id = Registry.getPacketId(packet.getClass());
        return new ServerToClientUniversalPacket(id, channel, packet);
    }

    private ClientToServerUniversalPacket preparePacket(ClientToServerPacket packet) {
        String channel = Registry.getChannelForPacket(packet.getClass().getName());
        int id = Registry.getPacketId(packet.getClass());
        return new ClientToServerUniversalPacket(id, channel, packet);
    }

    @Override
    public void onReceiveClient(UniversalPacket packetRepresent, String channel) {
        ((ServerToClientPacket)this.readObjectFromPacket(packetRepresent, channel)).onReceive(ForgeNetworkImpl.mc());
    }

    @Override
    public void onReceiveServer(UniversalPacket packetRepresent, EntityPlayerMP player, String channel) {
        ((ClientToServerPacket)this.readObjectFromPacket(packetRepresent, channel)).onReceive(player);
    }

    private <A> A readObjectFromPacket(UniversalPacket packetRepresent, String channel) {
        return packetRepresent.getPacket(channel);
    }

    @Override
    public void registerChannel(String channel) {
        SimpleNetworkWrapper simpleNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel(channel);
        this.channels.put(channel, simpleNetworkWrapper);
        simpleNetworkWrapper.registerMessage((message, ctx) -> {
            if (!ForgeNetworkImpl.mc().func_152345_ab()) {
                ForgeNetworkImpl.mc().func_152344_a(() -> this.onReceiveClient((UniversalPacket)message, channel));
            } else {
                this.onReceiveClient((UniversalPacket)message, channel);
            }
            return null;
        }, ServerToClientUniversalPacket.class, 0, Side.CLIENT);
        simpleNetworkWrapper.registerMessage((message, ctx) -> {
            MinecraftServer mc = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (!mc.func_152345_ab()) {
                mc.func_152344_a(() -> this.onReceiveServer((UniversalPacket)message, ctx.getServerHandler().field_147369_b, channel));
            } else {
                this.onReceiveServer((UniversalPacket)message, ctx.getServerHandler().field_147369_b, channel);
            }
            return null;
        }, ClientToServerUniversalPacket.class, 1, Side.SERVER);
    }

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static class UniversalPacket<A extends IByteBufSerializable>
    implements IMessage {
        private int id;
        private A packet;
        private ByteBuf buf;

        A getPacket(String channel) {
            this.id = this.buf.readByte();
            String packetName = Registry.getPacketName(channel, this.id);
            return (A)((IByteBufSerializable)Registry.getSerializer(packetName).unserialize(this.buf));
        }

        public void fromBytes(ByteBuf buf) {
            this.buf = buf.copy();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.id);
            Registry.getSerializer(this.packet.getClass().getName()).serialize(this.packet, buf);
        }

        public UniversalPacket(int id, A packet, ByteBuf buf) {
            this.id = id;
            this.packet = packet;
            this.buf = buf;
        }

        public UniversalPacket() {
        }
    }

    public static class ServerToClientUniversalPacket
    extends UniversalPacket<ServerToClientPacket> {
        public ServerToClientUniversalPacket(int id, String channel, ServerToClientPacket packet) {
            super(id, packet, null);
        }

        public ServerToClientUniversalPacket() {
        }
    }

    public static class ClientToServerUniversalPacket
    extends UniversalPacket<ClientToServerPacket> {
        public ClientToServerUniversalPacket(int id, String channel, ClientToServerPacket packet) {
            super(id, packet, null);
        }

        public ClientToServerUniversalPacket() {
        }
    }
}

