/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.util;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.multipart.ICondition;

public class PredicateHelper {
    public static List<Predicate<IBlockState>> toCanonicalList(Iterable<? extends ICondition> conditions, BlockStateContainer stateContainer) {
        ArrayList<Predicate<IBlockState>> list = new ArrayList<Predicate<IBlockState>>();
        for (ICondition iCondition : conditions) {
            list.add((Predicate<IBlockState>)iCondition.func_188118_a(stateContainer));
        }
        PredicateHelper.canonize(list);
        return list;
    }

    public static <T> void canonize(List<Predicate<T>> input) {
        input.sort(Comparator.comparingInt(Object::hashCode));
        if (input instanceof ArrayList) {
            ((ArrayList)input).trimToSize();
        }
    }

    public static <T> Predicate<T> and(List<Predicate<T>> list) {
        return state -> {
            for (Predicate predicate : list) {
                if (predicate.test(state)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> or(List<Predicate<T>> list) {
        return state -> {
            for (Predicate predicate : list) {
                if (!predicate.test(state)) continue;
                return true;
            }
            return false;
        };
    }
}

