/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.searchtree;

import com.google.common.base.Stopwatch;
import java.util.List;
import net.minecraft.client.util.SearchTree;
import org.embeddedt.vintagefix.VintageFix;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SearchTree.class})
public abstract class SearchTreeMixin<T> {
    private static final ThreadLocal<Boolean> DEFER_RECALCULATION = ThreadLocal.withInitial(() -> true);
    private volatile boolean vfix$needsRecalculation;
    @Shadow
    @Final
    private List<T> field_194048_e;

    @Shadow
    public abstract void func_194040_a();

    @Inject(method={"recalculate()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void deferRecalculation(CallbackInfo ci) {
        if (DEFER_RECALCULATION.get().booleanValue()) {
            this.vfix$needsRecalculation = true;
            ci.cancel();
        }
    }

    @Redirect(method={"add(Ljava/lang/Object;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/util/SearchTree;index(Ljava/lang/Object;)V"))
    private void skipIndex(SearchTree<T> tree, Object o) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"search(Ljava/lang/String;)Ljava/util/List;"}, at={@At(value="HEAD")})
    private void recalculateBeforeSearch(CallbackInfoReturnable<List<T>> cir) {
        if (this.vfix$needsRecalculation) {
            SearchTreeMixin searchTreeMixin = this;
            synchronized (searchTreeMixin) {
                if (this.vfix$needsRecalculation) {
                    DEFER_RECALCULATION.set(false);
                    VintageFix.LOGGER.info("Building search tree for {} items (this may take a while)...", (Object)this.field_194048_e.size());
                    Stopwatch watch = Stopwatch.createStarted();
                    try {
                        this.func_194040_a();
                    }
                    finally {
                        DEFER_RECALCULATION.set(true);
                    }
                    watch.stop();
                    VintageFix.LOGGER.info("Building search tree for {} items took {}", (Object)this.field_194048_e.size(), (Object)watch);
                    this.vfix$needsRecalculation = false;
                }
            }
        }
    }
}

