/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.fastmap;

import net.minecraft.block.properties.IProperty;
import org.embeddedt.vintagefix.fastmap.FastMapKey;

public class CompactFastMapKey<T extends Comparable<T>>
extends FastMapKey<T> {
    private final int mapFactor;

    CompactFastMapKey(IProperty<T> property, int mapFactor) {
        super(property);
        this.mapFactor = mapFactor;
    }

    @Override
    public T getValue(int mapIndex) {
        int index = mapIndex / this.mapFactor % this.numValues();
        return this.byInternalIndex(index);
    }

    @Override
    public int replaceIn(int mapIndex, T newValue) {
        int lowerData = mapIndex % this.mapFactor;
        int upperFactor = this.mapFactor * this.numValues();
        int upperData = mapIndex - mapIndex % upperFactor;
        int internalIndex = this.getInternalIndex((Comparable<?>)newValue);
        if (internalIndex < 0 || internalIndex >= this.numValues()) {
            return -1;
        }
        return lowerData + this.mapFactor * internalIndex + upperData;
    }

    @Override
    public int toPartialMapIndex(Comparable<?> value) {
        return this.mapFactor * this.getInternalIndex(value);
    }

    @Override
    public int getFactorToNext() {
        return this.numValues();
    }
}

