/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.bonemealtweaker.config.json;

import mod.acgaming.bonemealtweaker.BonemealTweaker;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;

public class SpawnBlock {
    private static final String FLOWER_ENTRY = "flowerEntry";
    private final String block;
    private final int weight;
    private IBlockState state;

    public SpawnBlock(String block, int weight) {
        this.block = block;
        this.weight = weight;
    }

    public IBlockState getBlockState() {
        if (FLOWER_ENTRY.equals(this.block)) {
            return null;
        }
        if (this.state == null) {
            String[] parts = this.block.split("\\[");
            Block b = Block.func_149684_b((String)parts[0]);
            if (b == null) {
                BonemealTweaker.LOGGER.error("Invalid block: {}", (Object)this.block);
                return null;
            }
            this.state = b.func_176223_P();
            if (parts.length > 1) {
                String[] properties;
                for (String prop : properties = parts[1].replace("]", "").split(",")) {
                    String[] kv = prop.split("=");
                    IProperty property = b.func_176194_O().func_185920_a(kv[0]);
                    if (property != null) {
                        try {
                            Object value = property.func_185929_b(kv[1]).orNull();
                            if (value != null) {
                                this.state = this.state.func_177226_a(property, (Comparable)value);
                                continue;
                            }
                            BonemealTweaker.LOGGER.error("Invalid value for property {} in block state: {}", (Object)kv[0], (Object)this.block);
                        }
                        catch (Exception e) {
                            BonemealTweaker.LOGGER.error("Failed to parse block state property: {}", (Object)this.block, (Object)e);
                        }
                        continue;
                    }
                    BonemealTweaker.LOGGER.error("Unknown property {} for block state: {}", (Object)kv[0], (Object)this.block);
                }
            }
        }
        return this.state;
    }

    public String getBlock() {
        return this.block;
    }

    public int getWeight() {
        return this.weight;
    }
}

