/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.bonemealtweaker.config.json;

import java.util.List;
import java.util.Random;
import mod.acgaming.bonemealtweaker.config.json.SpawnBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;

public class BlockConfig {
    private final ResourceLocation replaceBlock;
    private final int iterations;
    private final List<String> biomes;
    private final List<Integer> dimensions;
    private final List<SpawnBlock> spawnBlocks;
    private final int totalWeight;

    public BlockConfig(ResourceLocation replaceBlock, int iterations, List<String> biomes, List<Integer> dimensions, List<SpawnBlock> spawnBlocks) {
        this.replaceBlock = replaceBlock;
        this.iterations = iterations;
        this.biomes = biomes;
        this.dimensions = dimensions;
        this.spawnBlocks = spawnBlocks;
        this.totalWeight = spawnBlocks.stream().mapToInt(SpawnBlock::getWeight).sum();
    }

    public IBlockState getRandomBlockState(Random rand) {
        int randWeight = rand.nextInt(this.totalWeight);
        int currentWeight = 0;
        for (SpawnBlock spawnBlock : this.spawnBlocks) {
            if (randWeight >= (currentWeight += spawnBlock.getWeight())) continue;
            return spawnBlock.getBlockState();
        }
        return null;
    }

    public ResourceLocation getReplaceBlock() {
        return this.replaceBlock;
    }

    public int getIterations() {
        return this.iterations;
    }

    public List<String> getBiomes() {
        return this.biomes;
    }

    public List<Integer> getDimensions() {
        return this.dimensions;
    }

    public List<SpawnBlock> getSpawnBlocks() {
        return this.spawnBlocks;
    }
}

