/*
 * Decompiled with CFR 0.152.
 */
package wiresegal.thicc.asm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ThiccAsmTransformer
implements IClassTransformer,
Opcodes {
    private static final String ASM_HOOKS = "wiresegal/thicc/asm/hooks/ThiccAsmHooks";
    private static final Map<String, Transformer> transformers = new HashMap<String, Transformer>();
    private static final String ENTITY = "net/minecraft/entity/Entity";

    private static byte[] transformEntity(byte[] basicClass) {
        MethodSignature size = new MethodSignature("setSize", "func_70105_a", "(FF)V");
        return ThiccAsmTransformer.transform(basicClass, size, "Size hook", method -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "rescale", "(Lnet/minecraft/entity/Entity;F)F", false));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(56, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "rescale", "(Lnet/minecraft/entity/Entity;F)F", false));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(56, 2));
            method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
            return true;
        });
    }

    private static byte[] transformRender(byte[] basicClass) {
        MethodSignature shadow = new MethodSignature("renderShadow", "func_76975_c", "(Lnet/minecraft/entity/Entity;DDDFF)V");
        FieldSignature size = new FieldSignature("shadowSize", "field_76989_e", "F");
        return ThiccAsmTransformer.transform(basicClass, shadow, "Resize shadow", ThiccAsmTransformer.combine(node -> node.getOpcode() == 180 && size.matches((FieldInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "rescale", "(FLnet/minecraft/entity/Entity;)F", false));
            method.instructions.insert(node, newInstructions);
            return false;
        }));
    }

    public static byte[] transform(byte[] basicClass, MethodSignature sig, String simpleDesc, MethodAction action) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        ThiccAsmTransformer.log("Applying Transformation to method (" + sig + ")");
        ThiccAsmTransformer.log("Attempting to insert: " + simpleDesc);
        boolean didAnything = ThiccAsmTransformer.findMethodAndTransform(node, sig, action);
        if (didAnything) {
            SafeClassWriter writer = new SafeClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static boolean findMethodAndTransform(ClassNode node, MethodSignature sig, MethodAction pred) {
        for (MethodNode method : node.methods) {
            if (!sig.matches(method)) continue;
            boolean finish = pred.test(method);
            ThiccAsmTransformer.log("Patch result: " + (finish ? "Success" : "!!!!!!! Failure !!!!!!!"));
            return finish;
        }
        ThiccAsmTransformer.log("Patch result: !!!!!!! Couldn't locate method! !!!!!!!");
        return false;
    }

    public static MethodAction combine(NodeFilter filter, NodeAction action) {
        return node -> ThiccAsmTransformer.applyOnNode(node, filter, action);
    }

    public static boolean applyOnNode(MethodNode method, NodeFilter filter, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator = new InsnArrayIterator(nodes);
        boolean didAny = false;
        while (iterator.hasNext()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator.next();
            if (!filter.test(anode)) continue;
            didAny = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return didAny;
    }

    public static MethodAction combineByLast(NodeFilter filter, NodeAction action) {
        return node -> ThiccAsmTransformer.applyOnNodeByLast(node, filter, action);
    }

    public static boolean applyOnNodeByLast(MethodNode method, NodeFilter filter, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator = new InsnArrayIterator(nodes, method.instructions.size());
        boolean didAny = false;
        while (iterator.hasPrevious()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator.previous();
            if (!filter.test(anode)) continue;
            didAny = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return didAny;
    }

    public static MethodAction combineFrontPivot(NodeFilter pivot, NodeFilter filter, NodeAction action) {
        return node -> ThiccAsmTransformer.applyOnNodeFrontPivot(node, pivot, filter, action);
    }

    public static boolean applyOnNodeFrontPivot(MethodNode method, NodeFilter pivot, NodeFilter filter, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator = new InsnArrayIterator(nodes);
        int pos = 0;
        boolean didAny = false;
        block0: while (iterator.hasNext()) {
            ++pos;
            AbstractInsnNode pivotTest = (AbstractInsnNode)iterator.next();
            if (!pivot.test(pivotTest)) continue;
            InsnArrayIterator internal = new InsnArrayIterator(nodes, pos);
            while (internal.hasPrevious()) {
                AbstractInsnNode anode = (AbstractInsnNode)internal.previous();
                if (!filter.test(anode)) continue;
                didAny = true;
                if (!action.test(method, anode)) continue;
                continue block0;
            }
        }
        return didAny;
    }

    public static MethodAction combineBackPivot(NodeFilter pivot, NodeFilter filter, NodeAction action) {
        return node -> ThiccAsmTransformer.applyOnNodeBackPivot(node, pivot, filter, action);
    }

    public static boolean applyOnNodeBackPivot(MethodNode method, NodeFilter pivot, NodeFilter filter, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator = new InsnArrayIterator(nodes, method.instructions.size());
        int pos = method.instructions.size();
        boolean didAny = false;
        block0: while (iterator.hasPrevious()) {
            --pos;
            AbstractInsnNode pivotTest = (AbstractInsnNode)iterator.previous();
            if (!pivot.test(pivotTest)) continue;
            InsnArrayIterator internal = new InsnArrayIterator(nodes, pos);
            while (internal.hasNext()) {
                AbstractInsnNode anode = (AbstractInsnNode)internal.next();
                if (!filter.test(anode)) continue;
                didAny = true;
                if (!action.test(method, anode)) continue;
                continue block0;
            }
        }
        return didAny;
    }

    public static MethodAction combineFrontFocus(NodeFilter focus, NodeFilter filter, NodeAction action) {
        return node -> ThiccAsmTransformer.applyOnNodeFrontFocus(node, focus, filter, action);
    }

    public static boolean applyOnNodeFrontFocus(MethodNode method, NodeFilter focus, NodeFilter filter, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator = new InsnArrayIterator(nodes);
        int pos = method.instructions.size();
        boolean didAny = false;
        block0: while (iterator.hasNext()) {
            ++pos;
            AbstractInsnNode focusTest = (AbstractInsnNode)iterator.next();
            if (!focus.test(focusTest)) continue;
            InsnArrayIterator internal = new InsnArrayIterator(nodes, pos);
            while (internal.hasNext()) {
                AbstractInsnNode anode = (AbstractInsnNode)internal.next();
                if (!filter.test(anode)) continue;
                didAny = true;
                if (!action.test(method, anode)) continue;
                continue block0;
            }
        }
        return didAny;
    }

    public static MethodAction combineBackFocus(NodeFilter focus, NodeFilter filter, NodeAction action) {
        return node -> ThiccAsmTransformer.applyOnNodeBackFocus(node, focus, filter, action);
    }

    public static boolean applyOnNodeBackFocus(MethodNode method, NodeFilter focus, NodeFilter filter, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator = new InsnArrayIterator(nodes, method.instructions.size());
        int pos = method.instructions.size();
        boolean didAny = false;
        block0: while (iterator.hasPrevious()) {
            --pos;
            AbstractInsnNode focusTest = (AbstractInsnNode)iterator.previous();
            if (!focus.test(focusTest)) continue;
            InsnArrayIterator internal = new InsnArrayIterator(nodes, pos);
            while (internal.hasPrevious()) {
                AbstractInsnNode anode = (AbstractInsnNode)internal.previous();
                if (!filter.test(anode)) continue;
                didAny = true;
                if (!action.test(method, anode)) continue;
                continue block0;
            }
        }
        return didAny;
    }

    public static void log(String str) {
        LogManager.getLogger((String)"Thicc ASM").info(str);
    }

    public static void prettyPrint(MethodNode node) {
        Textifier printer = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)printer);
        node.accept((MethodVisitor)visitor);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        ThiccAsmTransformer.log(sw.toString());
    }

    public static void prettyPrint(AbstractInsnNode node) {
        Textifier printer = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)printer);
        node.accept((MethodVisitor)visitor);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        ThiccAsmTransformer.log(sw.toString());
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformers.containsKey(transformedName)) {
            String[] arr = transformedName.split("\\.");
            ThiccAsmTransformer.log("Transforming " + arr[arr.length - 1]);
            return (byte[])transformers.get(transformedName).apply(basicClass);
        }
        return basicClass;
    }

    static {
        transformers.put("net.minecraft.entity.Entity", ThiccAsmTransformer::transformEntity);
        transformers.put("net.minecraft.client.renderer.entity.Render", ThiccAsmTransformer::transformRender);
    }

    public static class SafeClassWriter
    extends ClassWriter {
        public SafeClassWriter(int flags) {
            super(flags);
        }

        public SafeClassWriter(ClassReader classReader, int flags) {
            super(classReader, flags);
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> d;
            Class<?> c;
            LaunchClassLoader classLoader = Launch.classLoader;
            try {
                c = Class.forName(type1.replace('/', '.'), false, (ClassLoader)classLoader);
                d = Class.forName(type2.replace('/', '.'), false, (ClassLoader)classLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                return "java/lang/Object";
            }
            while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
            }
            return c.getName().replace('.', '/');
        }
    }

    public static class FieldSignature {
        private final String fieldName;
        private final String srgName;
        private final String fieldDesc;

        public FieldSignature(String fieldName, String srgName, String fieldDesc) {
            this.fieldName = fieldName;
            this.srgName = srgName;
            this.fieldDesc = fieldDesc;
        }

        public String toString() {
            return "Names [" + this.fieldName + ", " + this.srgName + "] Descriptor " + this.fieldDesc;
        }

        public boolean matches(String fieldName, String fieldDesc) {
            return (fieldName.equals(this.fieldName) || fieldName.equals(this.srgName)) && fieldDesc.equals(this.fieldDesc);
        }

        public boolean matches(FieldInsnNode field) {
            return this.matches(field.name, field.desc);
        }

        public boolean matches(FieldNode field) {
            return this.matches(field.name, field.desc);
        }
    }

    public static class MethodSignature {
        private final String funcName;
        private final String srgName;
        private final String funcDesc;

        public MethodSignature(String funcName, String srgName, String funcDesc) {
            this.funcName = funcName;
            this.srgName = srgName;
            this.funcDesc = funcDesc;
        }

        public String toString() {
            return "Names [" + this.funcName + ", " + this.srgName + "] Descriptor " + this.funcDesc;
        }

        public boolean matches(String methodName, String methodDesc) {
            return (methodName.equals(this.funcName) || methodName.equals(this.srgName)) && methodDesc.equals(this.funcDesc);
        }

        public boolean matches(MethodNode method) {
            return this.matches(method.name, method.desc);
        }

        public boolean matches(MethodInsnNode method) {
            return this.matches(method.name, method.desc);
        }
    }

    private static class InsnArrayIterator
    implements ListIterator<AbstractInsnNode> {
        private final AbstractInsnNode[] array;
        private int index;

        public InsnArrayIterator(AbstractInsnNode[] array) {
            this(array, 0);
        }

        public InsnArrayIterator(AbstractInsnNode[] array, int index) {
            this.array = array;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.array.length > this.index + 1 && this.index >= 0;
        }

        @Override
        public AbstractInsnNode next() {
            if (this.hasNext()) {
                return this.array[++this.index];
            }
            return null;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0 && this.index <= this.array.length;
        }

        @Override
        public AbstractInsnNode previous() {
            if (this.hasPrevious()) {
                return this.array[--this.index];
            }
            return null;
        }

        @Override
        public int nextIndex() {
            return this.hasNext() ? this.index + 1 : this.array.length;
        }

        @Override
        public int previousIndex() {
            return this.hasPrevious() ? this.index - 1 : 0;
        }

        @Override
        public void remove() {
            throw new Error("Unimplemented");
        }

        @Override
        public void set(AbstractInsnNode e) {
            throw new Error("Unimplemented");
        }

        @Override
        public void add(AbstractInsnNode e) {
            throw new Error("Unimplemented");
        }
    }

    public static interface NodeAction
    extends BiPredicate<MethodNode, AbstractInsnNode> {
    }

    public static interface NodeFilter
    extends Predicate<AbstractInsnNode> {
    }

    public static interface MethodAction
    extends Predicate<MethodNode> {
    }

    public static interface Transformer
    extends Function<byte[], byte[]> {
    }
}

