/*
 * Decompiled with CFR 0.152.
 */
package wiresegal.thicc;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wiresegal.thicc.ThiccConfig;

@Mod(modid="thiccentities", name="Thicc Entities", version="GRADLE:VERSION", guiFactory="wiresegal.thicc.client.ThiccGooeyHandler", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class ThiccEntities {
    public static final String THICC = "thiccentities";
    public static ThiccConfig config;
    private static final String SPEED_ATT = "Thicc Speed";
    private static final String FSPEED_ATT = "Thicc Flight Speed";
    private static final String HEALTH_ATT = "Thicc Health";
    private static final String FOLLOW_ATT = "Thicc Follow";
    private static final String DAMAGE_ATT = "Thicc Damage";
    private static final String ARMOR_ATT = "Thicc Armor";
    private static final String TOUGH_ATT = "Thicc Tough";
    private static final String REACH_ATT = "Thicc Reach";
    private static final UUID SPEED_UUID;
    private static final UUID FSPEED_UUID;
    private static final UUID HEALTH_UUID;
    private static final UUID FOLLOW_UUID;
    private static final UUID DAMAGE_UUID;
    private static final UUID ARMOR_UUID;
    private static final UUID TOUGH_UUID;
    private static final UUID REACH_UUID;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderPre(RenderLivingEvent.Pre e) {
        GlStateManager.func_179094_E();
        float scale = ThiccEntities.getScaleFactor((Entity)e.getEntity());
        if (scale > 0.0f && scale != 1.0f) {
            float scMinusOne = scale - 1.0f;
            GlStateManager.func_179137_b((double)(-e.getX() * (double)scMinusOne), (double)(-e.getY() * (double)scMinusOne), (double)(-e.getZ() * (double)scMinusOne));
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderPost(RenderLivingEvent.Post e) {
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public static void configReloaded(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equals(THICC)) {
            config.init();
        }
    }

    private static void applyAttribute(Multimap<String, AttributeModifier> attributes, IAttribute attribute, UUID uuid, String name, double value, int operation) {
        attributes.put((Object)attribute.func_111108_a(), (Object)new AttributeModifier(uuid, name, value - (double)(operation != 0 ? 1 : 0), operation).func_111168_a(false));
    }

    @SubscribeEvent
    public static void entityAttributes(EntityJoinWorldEvent e) {
        Entity ent = e.getEntity();
        if (ent instanceof EntityLivingBase && !(ent instanceof EntityArmorStand)) {
            EntityLivingBase entity = (EntityLivingBase)ent;
            ResourceLocation loc = ent instanceof EntityPlayer ? new ResourceLocation("player") : EntityList.func_191301_a((Entity)entity);
            HashMultimap attributes = HashMultimap.create();
            ThiccEntities.applyAttribute((Multimap<String, AttributeModifier>)attributes, SharedMonsterAttributes.field_111263_d, SPEED_UUID, SPEED_ATT, config.getConfigSpeed(loc), 1);
            ThiccEntities.applyAttribute((Multimap<String, AttributeModifier>)attributes, SharedMonsterAttributes.field_193334_e, FSPEED_UUID, FSPEED_ATT, config.getConfigSpeed(loc), 1);
            ThiccEntities.applyAttribute((Multimap<String, AttributeModifier>)attributes, SharedMonsterAttributes.field_111267_a, HEALTH_UUID, HEALTH_ATT, config.getConfigHealth(loc), 1);
            ThiccEntities.applyAttribute((Multimap<String, AttributeModifier>)attributes, SharedMonsterAttributes.field_111265_b, FOLLOW_UUID, FOLLOW_ATT, config.getConfigFollow(loc), 1);
            ThiccEntities.applyAttribute((Multimap<String, AttributeModifier>)attributes, SharedMonsterAttributes.field_111264_e, DAMAGE_UUID, DAMAGE_ATT, config.getConfigDamage(loc), 1);
            ThiccEntities.applyAttribute((Multimap<String, AttributeModifier>)attributes, EntityPlayer.REACH_DISTANCE, REACH_UUID, REACH_ATT, config.getConfigReach(loc), 1);
            ThiccEntities.applyAttribute((Multimap<String, AttributeModifier>)attributes, SharedMonsterAttributes.field_188791_g, ARMOR_UUID, ARMOR_ATT, config.getConfigArmor(loc), 0);
            ThiccEntities.applyAttribute((Multimap<String, AttributeModifier>)attributes, SharedMonsterAttributes.field_189429_h, TOUGH_UUID, TOUGH_ATT, config.getConfigToughness(loc), 0);
            entity.func_110140_aT().func_111147_b((Multimap)attributes);
        }
    }

    @SubscribeEvent
    public static void jump(LivingEvent.LivingJumpEvent e) {
        Entity entity = e.getEntity();
        ResourceLocation loc = entity instanceof EntityPlayer ? new ResourceLocation("player") : EntityList.func_191301_a((Entity)entity);
        entity.field_70181_x *= config.getConfigJump(loc);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new ThiccConfig(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        config.init();
    }

    public static float getScaleFactor(Entity entity) {
        ResourceLocation loc = entity instanceof EntityPlayer ? new ResourceLocation("player") : EntityList.func_191301_a((Entity)entity);
        return config.getConfigScale(loc);
    }

    static {
        SPEED_UUID = UUID.fromString("89194793-81a2-4dd9-854a-cd279dd90db1");
        FSPEED_UUID = UUID.fromString("3bc6f90b-74a5-4d2f-a9fb-56d18ed3eac0");
        HEALTH_UUID = UUID.fromString("3bb25fff-6a9c-47d0-8f07-13bd6a1e676c");
        FOLLOW_UUID = UUID.fromString("1ce8c66a-6c86-4594-9563-a1a8c2147552");
        DAMAGE_UUID = UUID.fromString("1d4d2d55-9b03-4eb1-8dba-caf8ef85440d");
        ARMOR_UUID = UUID.fromString("99f8aa85-0669-4976-819e-55cc4c6fe68e");
        TOUGH_UUID = UUID.fromString("37949588-c60d-4733-976a-c40e15b3f978");
        REACH_UUID = UUID.fromString("21df8e07-e1e5-41a8-9b90-5230b1453055");
    }
}

