/*
 * Decompiled with CFR 0.152.
 */
package wiresegal.thicc;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

public class ThiccConfig {
    public Configuration configInstance;
    private final Map<ResourceLocation, Double> SCALE_CONFIG = new HashMap<ResourceLocation, Double>();
    private final Map<ResourceLocation, Double> SPEED_CONFIG = new HashMap<ResourceLocation, Double>();
    private final Map<ResourceLocation, Double> DAMAGE_CONFIG = new HashMap<ResourceLocation, Double>();
    private final Map<ResourceLocation, Double> FOLLOW_CONFIG = new HashMap<ResourceLocation, Double>();
    private final Map<ResourceLocation, Double> HEALTH_CONFIG = new HashMap<ResourceLocation, Double>();
    private final Map<ResourceLocation, Double> ARMOR_CONFIG = new HashMap<ResourceLocation, Double>();
    private final Map<ResourceLocation, Double> TOUGH_CONFIG = new HashMap<ResourceLocation, Double>();
    private final Map<ResourceLocation, Double> REACH_CONFIG = new HashMap<ResourceLocation, Double>();
    private final Map<ResourceLocation, Double> JUMP_CONFIG = new HashMap<ResourceLocation, Double>();
    private final File configFile;

    public float getConfigScale(ResourceLocation name) {
        return this.SCALE_CONFIG.getOrDefault(name, 1.0).floatValue();
    }

    public double getConfigSpeed(ResourceLocation name) {
        return this.SPEED_CONFIG.getOrDefault(name, 1.0);
    }

    public double getConfigDamage(ResourceLocation name) {
        return this.DAMAGE_CONFIG.getOrDefault(name, 1.0);
    }

    public double getConfigFollow(ResourceLocation name) {
        return this.FOLLOW_CONFIG.getOrDefault(name, 1.0);
    }

    public double getConfigHealth(ResourceLocation name) {
        return this.HEALTH_CONFIG.getOrDefault(name, 1.0);
    }

    public double getConfigArmor(ResourceLocation name) {
        return this.ARMOR_CONFIG.getOrDefault(name, 0.0);
    }

    public double getConfigToughness(ResourceLocation name) {
        return this.TOUGH_CONFIG.getOrDefault(name, 0.0);
    }

    public double getConfigReach(ResourceLocation name) {
        return this.REACH_CONFIG.getOrDefault(name, 1.0);
    }

    public double getConfigJump(ResourceLocation name) {
        return this.JUMP_CONFIG.getOrDefault(name, 1.0);
    }

    public ThiccConfig(File configFile) {
        this.configFile = configFile;
    }

    public void init() {
        if (this.configInstance == null) {
            this.configInstance = new Configuration(this.configFile, true);
        } else {
            this.configInstance.load();
        }
        ResourceLocation player = new ResourceLocation("player");
        for (ResourceLocation location : Sets.union((Set)EntityList.func_180124_b(), (Set)Sets.newHashSet((Object[])new ResourceLocation[]{player}))) {
            Class entityClass = location == player ? EntityPlayer.class : EntityList.getClass((ResourceLocation)location);
            if (entityClass == null || entityClass == EntityArmorStand.class || !EntityLivingBase.class.isAssignableFrom(entityClass) || IEntityMultiPart.class.isAssignableFrom(entityClass)) continue;
            this.SCALE_CONFIG.put(location, this.configInstance.get(location.func_110624_b() + "." + location.func_110623_a(), "scale", 1.0, "The factor to scale the entity by. Default: 1").setRequiresWorldRestart(true).getDouble(1.0));
            this.SPEED_CONFIG.put(location, this.configInstance.get(location.func_110624_b() + "." + location.func_110623_a(), "speed", 1.0, "The factor to scale the entity's speed by. Default: 1").setRequiresWorldRestart(true).getDouble(1.0));
            this.DAMAGE_CONFIG.put(location, this.configInstance.get(location.func_110624_b() + "." + location.func_110623_a(), "damage", 1.0, "The factor to scale the entity's damage by. Default: 1").setRequiresWorldRestart(true).getDouble(1.0));
            this.HEALTH_CONFIG.put(location, this.configInstance.get(location.func_110624_b() + "." + location.func_110623_a(), "health", 1.0, "The factor to scale the entity's max health by. Default: 1").setRequiresWorldRestart(true).getDouble(1.0));
            this.JUMP_CONFIG.put(location, this.configInstance.get(location.func_110624_b() + "." + location.func_110623_a(), "jump", 1.0, "The factor to scale the player's jump strength by. Default: 1").setRequiresWorldRestart(true).getDouble(1.0));
            this.ARMOR_CONFIG.put(location, this.configInstance.get(location.func_110624_b() + "." + location.func_110623_a(), "armor", 0.0, "The amount of extra armor to give the entity. Default: 0").setRequiresWorldRestart(true).getDouble(0.0));
            this.TOUGH_CONFIG.put(location, this.configInstance.get(location.func_110624_b() + "." + location.func_110623_a(), "toughness", 0.0, "The amount of extra armor toughness to give the entity. Default: 0").setRequiresWorldRestart(true).getDouble(0.0));
            if (EntityLiving.class.isAssignableFrom(entityClass)) {
                this.FOLLOW_CONFIG.put(location, this.configInstance.get(location.func_110624_b() + "." + location.func_110623_a(), "followRange", 1.0, "The factor to scale the entity's follow range by. Default: 1").setRequiresWorldRestart(true).getDouble(1.0));
            }
            if (!EntityPlayer.class.isAssignableFrom(entityClass)) continue;
            this.REACH_CONFIG.put(location, this.configInstance.get(location.func_110624_b() + "." + location.func_110623_a(), "reach", 1.0, "The factor to scale the entity's reach distance by. Default: 1").setRequiresWorldRestart(true).getDouble(1.0));
        }
        this.configInstance.save();
    }
}

