/*
 * Decompiled with CFR 0.152.
 */
package coolsquid.hungertweaker.util;

import crafttweaker.api.data.DataByte;
import crafttweaker.api.data.DataDouble;
import crafttweaker.api.data.DataFloat;
import crafttweaker.api.data.DataInt;
import crafttweaker.api.data.DataLong;
import crafttweaker.api.data.DataShort;
import crafttweaker.api.data.DataString;
import crafttweaker.api.data.IData;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Util {
    public static boolean isNumber(IData data) {
        return data instanceof DataByte || data instanceof DataDouble || data instanceof DataFloat || data instanceof DataInt || data instanceof DataLong || data instanceof DataShort;
    }

    public static Event.Result parseResult(IData data) {
        if (Util.isNumber(data)) {
            int index = data.asInt();
            switch (index) {
                case 0: {
                    return Event.Result.DENY;
                }
                case 1: {
                    return Event.Result.DEFAULT;
                }
                case 2: {
                    return Event.Result.ALLOW;
                }
            }
            throw new IllegalArgumentException("Unknown status/result: " + index + ". Possible values are: 0, 1 and 2.");
        }
        if (data instanceof DataString) {
            try {
                return Event.Result.valueOf((String)data.asString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                StringBuilder values = new StringBuilder();
                if (Event.Result.values().length > 0) {
                    values.append('\'').append(Event.Result.values()[0].name()).append('\'');
                    if (Event.Result.values().length > 1) {
                        for (int i = 1; i < Event.Result.values().length - 1; ++i) {
                            values.append(", '").append(Event.Result.values()[i].name()).append('\'');
                        }
                        values.append(" and '").append(Event.Result.values()[Event.Result.values().length - 1].name()).append('\'');
                    }
                }
                throw new IllegalArgumentException("Unknown status/result: '" + data.asString() + "'. Possible values are: " + values.toString() + ".", e);
            }
        }
        throw new IllegalArgumentException("The argument must be a string or a number.");
    }
}

