/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element.button;

import java.util.function.Consumer;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.element.button.UIButtonBase;
import net.shadowfacts.shadowmc.ui.util.UIHelper;
import net.shadowfacts.shadowmc.util.MouseButton;

public class UIButtonToggle
extends UIButtonBase {
    private boolean state;
    protected Consumer<UIButtonToggle> callback;

    public UIButtonToggle(boolean state, Consumer<UIButtonToggle> callback, String id, String ... classes) {
        super("button-toggle", id, classes);
        this.state = state;
        this.callback = callback;
    }

    public UIButtonToggle(Consumer<UIButtonToggle> callback, String id, String ... classes) {
        this(true, callback, id, classes);
    }

    public boolean getState() {
        return this.state;
    }

    @Override
    protected boolean handlePress(int mouseX, int mouseY, MouseButton button) {
        this.state = !this.state;
        this.callback.accept(this);
        return true;
    }

    @Override
    protected void drawButton(int mouseX, int mouseY) {
        UIHelper.bindTexture(TEXTURE);
        int u = this.state ? 0 : 20;
        UIHelper.drawTexturedRect(this.x, this.y, u, 0, this.dimensions.width, this.dimensions.height);
    }

    @Override
    public UIDimensions getMinDimensions() {
        return this.getPreferredDimensions();
    }

    @Override
    public UIDimensions getPreferredDimensions() {
        return new UIDimensions(20, 20);
    }

    public void setState(boolean state) {
        this.state = state;
    }
}

