/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element.button;

import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.EnumDyeColor;
import net.shadowfacts.shadowlib.util.EnumUtils;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.element.button.UIButtonBase;
import net.shadowfacts.shadowmc.ui.util.UIHelper;
import net.shadowfacts.shadowmc.util.MouseButton;

public class UIButtonDyeColor
extends UIButtonBase {
    private Consumer<EnumDyeColor> handler;
    private EnumDyeColor color;

    public UIButtonDyeColor(EnumDyeColor color, Consumer<EnumDyeColor> handler, String id, String ... classes) {
        super("button-dye-color", id, classes);
        this.tooltip = list -> list.add(I18n.func_135052_a((String)("shadowmc.dye." + this.getColor().func_176762_d()), (Object[])new Object[0]));
        this.color = color;
        this.handler = handler;
    }

    public UIButtonDyeColor(Consumer<EnumDyeColor> handler, String id, String ... classes) {
        this(EnumDyeColor.WHITE, handler, id, classes);
    }

    @Override
    protected boolean handlePress(int mouseX, int mouseY, MouseButton button) {
        if (button == MouseButton.LEFT) {
            this.color = EnumUtils.getNextValue(this.color);
            this.handler.accept(this.color);
        } else if (button == MouseButton.RIGHT) {
            this.color = EnumUtils.getPreviousValue(this.color);
            this.handler.accept(this.color);
        }
        return true;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        super.draw(mouseX, mouseY);
    }

    @Override
    protected void drawButton(int mouseX, int mouseY) {
        UIHelper.drawRect(this.x + 4, this.y + 4, this.dimensions.width - 8, this.dimensions.height - 8, new Color(this.color.func_193350_e()));
    }

    @Override
    public UIDimensions getMinDimensions() {
        return this.getPreferredDimensions();
    }

    @Override
    public UIDimensions getPreferredDimensions() {
        return new UIDimensions(20, 20);
    }

    public EnumDyeColor getColor() {
        return this.color;
    }
}

