/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.element.UIBarIndicator;
import net.shadowfacts.shadowmc.ui.style.UIAttribute;
import net.shadowfacts.shadowmc.ui.style.UIOrientation;
import net.shadowfacts.shadowmc.ui.util.UIHelper;

public class UITexturedBarIndicator
extends UIBarIndicator {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("shadowmc", "textures/gui/widgets.png");

    public UITexturedBarIndicator(Supplier<Float> levelSupplier, Consumer<List<String>> tooltip2, String id, String ... classes) {
        super(levelSupplier, tooltip2, id, classes);
        this.setStyle(UIAttribute.PRIMARY_COLOR, new Color(0xFF00007, true));
        this.setStyle(UIAttribute.SECONDARY_COLOR, new Color(0x330000BB, true));
    }

    public UITexturedBarIndicator(Supplier<Float> levelSupplier, String id, String ... classes) {
        this(levelSupplier, ImmutableList::of, id, classes);
    }

    @Override
    public UIDimensions getMaxDimensions() {
        return new UIDimensions(20, UIDimensions.max().height);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        int filled;
        float level = ((Float)this.levelSupplier.get()).floatValue();
        UIHelper.bindTexture(TEXTURE);
        Color primaryColor = this.getStyle(UIAttribute.PRIMARY_COLOR);
        Color secondaryColor = this.getStyle(UIAttribute.SECONDARY_COLOR);
        UIOrientation orientation = this.getStyle(UIAttribute.ORIENTATION);
        if (orientation == UIOrientation.VERTICAL) {
            filled = Math.min((int)(level * (float)this.dimensions.height), this.dimensions.height);
            for (int i = 0; i < this.dimensions.height / 50; ++i) {
                UIHelper.drawTexturedRect(this.x, this.y + i * 50, 0, 20, this.dimensions.width, i * 50);
            }
            if (this.dimensions.height % 50 != 0) {
                UIHelper.drawTexturedRect(this.x, this.y + this.dimensions.height - this.dimensions.height % 50, 0, 20, this.dimensions.width, this.dimensions.height % 50);
            }
            UIHelper.drawRect(this.x, this.y + (this.dimensions.height - filled), this.dimensions.width, filled, primaryColor, 0.005f);
            UIHelper.drawRect(this.x, this.y, this.dimensions.width, this.dimensions.height - filled, secondaryColor, 0.005f);
        } else {
            filled = Math.min((int)(level * (float)this.dimensions.width), this.dimensions.width);
            for (int i = 0; i < this.dimensions.width / 50; ++i) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                UIHelper.drawTexturedRect(this.x + i * 50, this.y, 0, 20, i * 50, this.dimensions.height);
                GlStateManager.func_179121_F();
            }
            if (this.dimensions.width % 50 != 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                UIHelper.drawTexturedRect(this.x + this.dimensions.width - this.dimensions.width % 50, this.y, 0, 20, this.dimensions.width % 50, this.dimensions.height);
                GlStateManager.func_179121_F();
            }
            UIHelper.drawRect(this.x + this.dimensions.width - filled, this.y, filled, this.dimensions.height, primaryColor);
            UIHelper.drawRect(this.x, this.y, this.dimensions.width - filled, this.dimensions.height, secondaryColor);
        }
        if (UIHelper.isWithinBounds(mouseX, mouseY, this.x, this.y, this.dimensions)) {
            ArrayList<String> tooltip2 = new ArrayList<String>();
            this.tooltip.accept(tooltip2);
            if (!tooltip2.isEmpty()) {
                UIHelper.drawHoveringText(tooltip2, mouseX, mouseY);
            }
        }
    }
}

