/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.IFluidTank;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.element.UIElementBase;
import net.shadowfacts.shadowmc.ui.style.UIAttribute;
import net.shadowfacts.shadowmc.ui.util.UIHelper;

public class UIFluidIndicator
extends UIElementBase {
    private IFluidTank tank;

    public UIFluidIndicator(IFluidTank tank, String id, String ... classes) {
        super("fluid-indicator", id, classes);
        this.tank = tank;
    }

    @Override
    public UIDimensions getMinDimensions() {
        return this.getPreferredDimensions();
    }

    @Override
    public UIDimensions getPreferredDimensions() {
        return new UIDimensions(20, 100);
    }

    @Override
    public UIDimensions getMaxDimensions() {
        return new UIDimensions(20, UIDimensions.max().height);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        UIHelper.drawRect(this.x, this.y, this.dimensions.width, this.dimensions.height, this.getStyle(UIAttribute.BORDER_COLOR));
        if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
            float level = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
            int height = this.dimensions.height - 4;
            int filled = Math.min((int)(level * (float)height), height);
            TextureAtlasSprite sprite = this.mc.func_147117_R().func_110572_b(this.tank.getFluid().getFluid().getStill(this.tank.getFluid()).toString());
            int x = this.x + 2;
            int y = this.y + (height - filled) + 2;
            float minU = sprite.func_94214_a(0.0);
            float minV = sprite.func_94207_b(0.0);
            float maxU = sprite.func_94214_a(16.0);
            float maxV = sprite.func_94207_b(16.0);
            for (int i = 0; i < filled / 16; ++i) {
                UIHelper.drawFluidQuad(x, y + i * 16, 16, 16, minU, minV, maxU, maxV);
            }
            if (filled % 16 != 0) {
                UIHelper.drawFluidQuad(x, y + filled - filled % 16, 16, filled % 16, minU, minV, maxU, sprite.func_94207_b((double)(filled % 16)));
            }
        }
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        if (UIHelper.isWithinBounds(mouseX, mouseY, this)) {
            ImmutableList tooltip2 = this.tank.getFluid() != null && this.tank.getFluidAmount() > 0 ? ImmutableList.of((Object)String.format("%s %d / %d mB", this.tank.getFluid().getLocalizedName(), this.tank.getFluidAmount(), this.tank.getCapacity())) : ImmutableList.of((Object)I18n.func_135052_a((String)"shadowmc.gui.empty", (Object[])new Object[0]));
            UIHelper.drawHoveringText((List<String>)tooltip2, mouseX, mouseY);
        }
    }
}

