/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowlib.version;

import net.shadowfacts.shadowlib.version.InvalidVersionException;
import net.shadowfacts.shadowlib.version.VersionMatcher;

public class Version {
    private int major;
    private int minor;
    private int patch;
    private String label;

    public Version(String v) {
        String[] arr = v.split("\\-");
        String[] arr2 = arr[0].split("\\.");
        if (arr2.length != 3) {
            throw new InvalidVersionException("Cannot create Version with %d version arguments", arr2.length);
        }
        this.major = Integer.parseInt(arr2[0]);
        this.minor = Integer.parseInt(arr2[1]);
        this.patch = Integer.parseInt(arr2[2]);
        if (arr.length == 2) {
            if (arr[1] == null) {
                throw new InvalidVersionException("Cannot create Version with null label");
            }
            if (arr[1].isEmpty()) {
                throw new InvalidVersionException("Cannot create Version with empty label");
            }
            this.label = arr[1];
        } else if (arr.length < 2) {
            for (int i = 1; i < arr.length - 1; ++i) {
                if (arr[i] == null) {
                    throw new InvalidVersionException("Cannot create Version with null label");
                }
                if (arr[i].equals("")) {
                    throw new InvalidVersionException("Cannot create Version with empty label");
                }
                this.label = this.label + arr[i];
            }
        }
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public Version(int major, int minor, int patch, String label) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.label = label;
    }

    public Version copy() {
        return new Version(this.major, this.minor, this.patch, this.label);
    }

    public Version incrementMajor(boolean resetLabel) {
        ++this.major;
        this.minor = 0;
        this.patch = 0;
        if (resetLabel) {
            this.label = "";
        }
        return this;
    }

    public Version incrementMajor() {
        return this.incrementMajor(false);
    }

    public Version incrementMinor(boolean resetLabel) {
        ++this.minor;
        this.patch = 0;
        if (resetLabel) {
            this.label = "";
        }
        return this;
    }

    public Version incrementMinor() {
        return this.incrementMinor(false);
    }

    public Version incrementPatch(boolean resetLabel) {
        ++this.patch;
        if (resetLabel) {
            this.label = "";
        }
        return this;
    }

    public Version incrementPatch() {
        return this.incrementPatch(false);
    }

    public Version setMajor(int major, boolean resetLabel) {
        this.major = major;
        if (resetLabel) {
            this.label = "";
        }
        return this;
    }

    public Version setMajor(int major) {
        return this.setMajor(major, false);
    }

    public Version setMinor(int minor, boolean resetLabel) {
        this.minor = minor;
        if (resetLabel) {
            this.label = "";
        }
        return this;
    }

    public Version setMinor(int minor) {
        return this.setMinor(minor, false);
    }

    public Version setPatch(int patch, boolean resetLabel) {
        this.patch = patch;
        if (resetLabel) {
            this.label = "";
        }
        return this;
    }

    public Version setPatch(int patch) {
        return this.setPatch(patch, false);
    }

    public Version setLabel(String label) {
        this.label = label;
        return this;
    }

    public Version removeLabel() {
        return this.setLabel("");
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean hasLabel() {
        return this.label != null && !this.label.isEmpty();
    }

    public String toString() {
        String s = String.format("%d.%d.%d", this.major, this.minor, this.patch);
        if (this.hasLabel()) {
            s = s + String.format("-%s", this.label);
        }
        return s;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version other = (Version)obj;
            if (other.major == this.major && other.minor == this.minor && other.patch == this.patch) {
                if (other.hasLabel() && this.hasLabel()) {
                    if (other.label.equals(this.label)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean greaterThan(Version other) {
        if (this.major > other.major) {
            return true;
        }
        if (this.major == other.major && this.minor > other.minor) {
            return true;
        }
        return this.major == other.major && this.minor == other.minor && this.patch > other.patch;
    }

    public boolean lessThan(Version other) {
        return other.greaterThan(this);
    }

    public boolean validFor(String matcherString) {
        return VersionMatcher.matches(matcherString, this);
    }
}

