/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.mirror;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.shadowfacts.mirror.Mirror;
import net.shadowfacts.mirror.MirrorClass;

public class MirrorConstructor<T> {
    private Constructor<T> constructor;

    MirrorConstructor(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    public Constructor<T> unwrap() {
        return this.constructor;
    }

    public MirrorClass<?>[] parameterTypes() {
        return (MirrorClass[])Mirror.ofAllUnwrapped(this.constructor.getParameterTypes()).toArray(MirrorClass[]::new);
    }

    public T invoke(Object ... args) {
        Class<?>[] parameterTypes = this.constructor.getParameterTypes();
        if (args.length != parameterTypes.length) {
            throw new IllegalArgumentException("Wrong number of arguments");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].isAssignableFrom(args[i].getClass())) continue;
            throw new IllegalArgumentException("Argument " + i + " was of wrong type. Expected " + parameterTypes[i].getName() + " got " + args[i].getClass().getName());
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MirrorConstructor that = (MirrorConstructor)o;
        return this.constructor.equals(that.constructor);
    }

    public int hashCode() {
        return this.constructor.hashCode();
    }
}

