/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.basketcase.tileentity;

import com.daeruin.basketcase.inventory.ItemStackHandlerBasket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityBasket
extends TileEntity {
    public int numSlots;
    private int maxStackSize;
    private ResourceLocation guiTexture;
    private ItemStackHandlerBasket inventory;

    public void initializeTileEntity(int numSlots, int maxStackSize, ResourceLocation guiTexture) {
        this.numSlots = numSlots;
        this.maxStackSize = maxStackSize;
        this.guiTexture = guiTexture;
        this.inventory = new ItemStackHandlerBasket(this.numSlots, this.maxStackSize, this.guiTexture);
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("numSlots", this.numSlots);
        compound.func_74768_a("maxStackSize", this.maxStackSize);
        compound.func_74778_a("guiTexture", this.guiTexture.toString());
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        int numSlots = compound.func_74762_e("numSlots");
        int maxStackSize = compound.func_74762_e("maxStackSize");
        ResourceLocation guiTexture = new ResourceLocation(compound.func_74779_i("guiTexture"));
        this.initializeTileEntity(numSlots, maxStackSize, guiTexture);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        super.func_145839_a(compound);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.handleUpdateTag(packet.func_148857_g());
    }
}

