/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.basketcase.network;

import com.daeruin.basketcase.BasketCase;
import com.daeruin.basketcase.inventory.ItemStackHandlerBasket;
import io.netty.buffer.ByteBuf;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;

public class BasketInventoryUpdate
implements IMessage {
    int slotIndex;
    NBTTagCompound nbt;

    public BasketInventoryUpdate() {
    }

    public BasketInventoryUpdate(int slotIndex, NBTTagCompound nbt) {
        this.slotIndex = slotIndex;
        this.nbt = nbt;
    }

    public void fromBytes(ByteBuf buf) {
        this.slotIndex = buf.readInt();
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slotIndex);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    @ParametersAreNonnullByDefault
    public static class Handler
    implements IMessageHandler<BasketInventoryUpdate, IMessage> {
        public IMessage onMessage(BasketInventoryUpdate message, MessageContext messageContext) {
            BasketCase.getProxy().getThreadListener(messageContext).func_152344_a(() -> {
                ItemStack stack;
                ItemStackHandlerBasket stackCapability;
                EntityPlayer player = BasketCase.getProxy().getPlayer(messageContext);
                if (player != null && (stackCapability = (ItemStackHandlerBasket)((Object)((Object)(stack = ((Slot)player.field_71070_bA.field_75151_b.get(message.slotIndex)).func_75211_c()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)))) != null) {
                    stackCapability.deserializeNBT(message.nbt);
                }
            });
            return null;
        }
    }
}

