/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.basketcase.items;

import com.daeruin.basketcase.BasketCase;
import com.daeruin.basketcase.blocks.BlockTileEntityBasket;
import com.daeruin.basketcase.config.BasketCaseConfig;
import com.daeruin.basketcase.inventory.BasketInventoryProvider;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemBlockBasket
extends ItemBlock {
    public ItemBlockBasket(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound compound) {
        BlockTileEntityBasket block = (BlockTileEntityBasket)this.func_179223_d();
        return new BasketInventoryProvider(block.getNumSlots(), block.getMaxStackSize(), block.getGuiTexture());
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        BlockPos posToCheck = pos;
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            posToCheck = pos.func_177972_a(facing).func_177977_b();
            state = worldIn.func_180495_p(posToCheck);
        }
        if (state.func_193401_d((IBlockAccess)worldIn, posToCheck, EnumFacing.UP) == BlockFaceShape.SOLID) {
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        return EnumActionResult.FAIL;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!BasketCaseConfig.basketsAreDecorativeOnly) {
            player.openGui((Object)BasketCase.INSTANCE, 0, world, 0, 0, 0);
        }
        return super.func_77659_a(world, player, hand);
    }

    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!BasketCaseConfig.basketsAreDecorativeOnly) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.basket", (Object[])new Object[0]));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

