/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.basketcase.inventory;

import com.daeruin.basketcase.inventory.SlotItemHandlerBasket;
import com.daeruin.basketcase.tileentity.TileEntityBasket;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ContainerBasket
extends Container {
    private static final int NUM_ROWS = 2;
    private static final int X_CENTER = 88;
    private static final int Y_START = 17;
    private static final int SLOT_SIZE = 18;
    private final TileEntityBasket tileEntityBasket;
    private final int numSlots;

    public ContainerBasket(IInventory playerInventory, IItemHandler basketInventory, TileEntityBasket tileEntityBasket, int numSlots) {
        int x;
        int y;
        this.tileEntityBasket = tileEntityBasket;
        this.numSlots = numSlots;
        int numColumns = numSlots / 2;
        int xStart = 88 - numColumns * 18 / 2;
        for (y = 0; y < 2; ++y) {
            for (x = 0; x < numColumns; ++x) {
                int slotIndex = x + y * numColumns;
                int xPosition = xStart + x * 18;
                int yPosition = 17 + y * 18;
                this.func_75146_a((Slot)new SlotItemHandlerBasket(basketInventory, slotIndex, xPosition, yPosition));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(playerInventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.func_75146_a(new Slot(playerInventory, x2, 8 + x2 * 18, 142));
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return this.tileEntityBasket == null || this.tileEntityBasket.isUsableByPlayer(playerIn);
    }

    protected boolean func_75135_a(ItemStack sourceStack, int startIndex, int endIndex, boolean useEndIndex) {
        ItemStack targetStack;
        Slot targetSlot;
        boolean success = false;
        int index = startIndex;
        if (useEndIndex) {
            index = endIndex - 1;
        }
        if (sourceStack.func_77985_e()) {
            while (sourceStack.func_190916_E() > 0 && (!useEndIndex && index < endIndex || useEndIndex && index >= startIndex)) {
                targetSlot = (Slot)this.field_75151_b.get(index);
                targetStack = targetSlot.func_75211_c();
                if (!(targetStack.func_190926_b() || targetStack.func_77973_b() != sourceStack.func_77973_b() || sourceStack.func_77981_g() && sourceStack.func_77960_j() != targetStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)sourceStack, (ItemStack)targetStack))) {
                    int maxTargetSize;
                    int combinedSize = targetStack.func_190916_E() + sourceStack.func_190916_E();
                    if (combinedSize <= (maxTargetSize = Math.min(targetStack.func_77976_d(), targetSlot.func_75219_a()))) {
                        sourceStack.func_190920_e(0);
                        targetStack.func_190920_e(combinedSize);
                        targetSlot.func_75218_e();
                        success = true;
                    } else if (targetStack.func_190916_E() < maxTargetSize) {
                        sourceStack.func_190918_g(maxTargetSize - targetStack.func_190916_E());
                        targetStack.func_190920_e(maxTargetSize);
                        targetSlot.func_75218_e();
                        success = true;
                    }
                }
                if (useEndIndex) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        if (sourceStack.func_190916_E() > 0) {
            index = useEndIndex ? endIndex - 1 : startIndex;
            while (sourceStack.func_190916_E() > 0 && (!useEndIndex && index < endIndex || useEndIndex && index >= startIndex)) {
                targetSlot = (Slot)this.field_75151_b.get(index);
                targetStack = targetSlot.func_75211_c();
                if (targetStack.func_190926_b() && targetSlot.func_75214_a(sourceStack)) {
                    if (sourceStack.func_190916_E() <= targetSlot.func_178170_b(sourceStack)) {
                        targetSlot.func_75215_d(sourceStack.func_77946_l());
                        targetSlot.func_75218_e();
                        sourceStack.func_190920_e(0);
                        success = true;
                        break;
                    }
                    ItemStack newStack = sourceStack.func_77946_l();
                    newStack.func_190920_e(targetSlot.func_178170_b(sourceStack));
                    targetSlot.func_75215_d(newStack);
                    targetSlot.func_75218_e();
                    sourceStack.func_190918_g(targetSlot.func_178170_b(sourceStack));
                    success = true;
                }
                if (useEndIndex) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        return success;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int fromSlotIndex) {
        ItemStack previous = ItemStack.field_190927_a;
        Slot fromSlot = (Slot)this.field_75151_b.get(fromSlotIndex);
        boolean CONTAINER_START = false;
        int CONTAINER_END = this.numSlots - 1;
        int PLAYER_INV_START = CONTAINER_END + 1;
        int PLAYER_INV_END = PLAYER_INV_START + 26;
        int HOT_BAR_START = PLAYER_INV_END + 1;
        int HOT_BAR_END = HOT_BAR_START + 8;
        if (fromSlot != null && fromSlot.func_75216_d()) {
            ItemStack current = fromSlot.func_75211_c();
            previous = current.func_77946_l();
            if (fromSlotIndex <= CONTAINER_END ? !this.func_75135_a(current, PLAYER_INV_START, HOT_BAR_END + 1, true) : !this.func_75135_a(current, 0, CONTAINER_END + 1, false)) {
                return ItemStack.field_190927_a;
            }
            if (current.func_190916_E() == 0) {
                fromSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                fromSlot.func_75218_e();
            }
            if (current.func_190916_E() == previous.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            fromSlot.func_190901_a(playerIn, current);
        }
        return previous;
    }
}

