/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.basketcase.inventory;

import com.daeruin.basketcase.inventory.ItemStackHandlerBasket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;

public class BasketInventoryProvider
implements ICapabilitySerializable {
    private final ItemStackHandlerBasket inventory;

    public BasketInventoryProvider(int numSlots, int maxStackSize, ResourceLocation guiTexture) {
        this.inventory = new ItemStackHandlerBasket(numSlots, maxStackSize, guiTexture);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)((Object)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : null));
    }

    public NBTBase serializeNBT() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.getStorage().writeNBT(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)this.inventory, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.getStorage().readNBT(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)this.inventory, null, nbt);
    }
}

