/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.basketcase.events;

import com.daeruin.basketcase.blocks.BlockRegistry;
import com.daeruin.basketcase.blocks.BlockTileEntityBasket;
import com.daeruin.basketcase.client.gui.GuiBasket;
import com.daeruin.basketcase.config.BasketCaseConfig;
import com.daeruin.basketcase.inventory.ContainerBasket;
import com.daeruin.basketcase.inventory.ItemStackHandlerBasket;
import com.daeruin.basketcase.items.ItemBlockBasket;
import com.daeruin.basketcase.items.ItemRegistry;
import com.daeruin.basketcase.network.BasketInventoryUpdate;
import com.daeruin.basketcase.network.PacketHandler;
import com.daeruin.basketcase.util.BasketCaseUtil;
import com.daeruin.primallib.blocks.PrimalBlockRegistry;
import com.daeruin.primallib.items.PrimalItemRegistry;
import com.daeruin.primallib.util.PrimalUtil;
import com.daeruin.primallib.util.PrimalUtilReg;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiShulkerBox;
import net.minecraft.client.player.inventory.ContainerLocalMenu;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerShulkerBox;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class EventHandler {
    private int mouseX;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        if (BasketCaseConfig.allowWoodSpecificBaskets) {
            List drops = event.getDrops();
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack currentItemStack = (ItemStack)drops.get(i);
                Item currentItem = currentItemStack.func_77973_b();
                if (currentItem != PrimalItemRegistry.TWIG_GENERIC) continue;
                IBlockState blockState = event.getState();
                Item itemToDrop = BasketCaseUtil.getTwig(blockState);
                ItemStack itemStackToDrop = new ItemStack(itemToDrop, currentItemStack.func_190916_E());
                drops.set(i, itemStackToDrop);
            }
        }
    }

    @SubscribeEvent
    public void entityItemPickupEvent(EntityItemPickupEvent event) {
        EntityItem entityItem;
        Item item;
        if (BasketCaseConfig.basketsRestrictedToHotBar && (item = (entityItem = event.getItem()).func_92059_d().func_77973_b()) instanceof ItemBlockBasket) {
            EntityPlayer player = event.getEntityPlayer();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!stack.func_190926_b()) continue;
                return;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onContainerClosed(PlayerContainerEvent.Close event) {
        if (BasketCaseConfig.basketsRestrictedToHotBar) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            Container playerContainer = player.field_71069_bz;
            for (Slot slot : playerContainer.field_75151_b) {
                ItemStack stackInSlot;
                int slotIndex = slot.getSlotIndex();
                if (slotIndex <= 8 || slotIndex == 40 || !((stackInSlot = slot.func_75211_c().func_77946_l()).func_77973_b() instanceof ItemBlockBasket)) continue;
                player.func_71019_a(stackInSlot, false);
                player.field_71071_by.func_70299_a(slotIndex, ItemStack.field_190927_a);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void guiMouse(GuiScreenEvent.MouseInputEvent.Pre event) {
        Slot slotUnderMouse;
        if (Mouse.getEventButton() == -1) {
            return;
        }
        GuiScreen gui = event.getGui();
        boolean shouldCancel = false;
        if (gui instanceof GuiContainer && (slotUnderMouse = ((GuiContainer)gui).getSlotUnderMouse()) != null) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Item itemOnCursor = player.field_71071_by.func_70445_o().func_77973_b();
            ItemStack stackUnderMouse = slotUnderMouse.func_75211_c();
            boolean bl = shouldCancel = !this.canItemBeMoved(itemOnCursor, slotUnderMouse, player.field_71070_bA);
            if (stackUnderMouse.func_77973_b() instanceof ItemBlockBasket && GuiContainer.func_146272_n() && (BasketCaseConfig.basketsRestrictedToHotBar || !BasketCaseConfig.basketsAllowedInContainers || gui instanceof GuiShulkerBox)) {
                shouldCancel = true;
            }
            if (Block.func_149634_a((Item)stackUnderMouse.func_77973_b()) instanceof BlockShulkerBox && GuiContainer.func_146272_n() && gui instanceof GuiBasket) {
                shouldCancel = true;
            }
            if (gui instanceof GuiBasket && stackUnderMouse.func_77973_b() instanceof ItemBlockBasket && PrimalUtil.isItemStackInMainHand((EntityPlayer)player, (ItemStack)stackUnderMouse)) {
                shouldCancel = true;
            }
        }
        event.setCanceled(shouldCancel);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void guiKey(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        Slot slotUnderMouse;
        GuiScreen gui = event.getGui();
        boolean shouldCancel = false;
        if (gui instanceof GuiContainer && (slotUnderMouse = ((GuiContainer)gui).getSlotUnderMouse()) != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack stackUnderMouse = slotUnderMouse.func_75211_c();
            for (int i = 0; i < minecraft.field_71474_y.field_151456_ac.length; ++i) {
                boolean keyPressedIsHotbarKey = minecraft.field_71474_y.field_151456_ac[i].isActiveAndMatches(Keyboard.getEventKey());
                if (!keyPressedIsHotbarKey) continue;
                ItemStack stackInTargetHotbarSlot = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                boolean bl = shouldCancel = !this.canItemBeMoved(stackInTargetHotbarSlot.func_77973_b(), slotUnderMouse, player.field_71070_bA);
                if (!(stackInTargetHotbarSlot.func_77973_b() instanceof ItemBlockBasket) || !PrimalUtil.isItemStackInMainHand((EntityPlayer)player, (ItemStack)stackInTargetHotbarSlot)) continue;
                shouldCancel = true;
            }
            if (minecraft.field_71474_y.field_74316_C.isActiveAndMatches(Keyboard.getEventKey()) && gui instanceof GuiBasket && stackUnderMouse.func_77973_b() instanceof ItemBlockBasket && PrimalUtil.isItemStackInMainHand((EntityPlayer)player, (ItemStack)stackUnderMouse)) {
                shouldCancel = true;
            }
        }
        event.setCanceled(shouldCancel);
    }

    private boolean canItemBeMoved(Item itemToBeMoved, Slot destinationSlot, Container openContainer) {
        IInventory destinationInventory = destinationSlot.field_75224_c;
        int slotIndex = destinationSlot.getSlotIndex();
        if (Block.func_149634_a((Item)itemToBeMoved) instanceof BlockShulkerBox) {
            if (openContainer instanceof ContainerBasket && destinationInventory instanceof InventoryBasic) {
                return false;
            }
        } else if (itemToBeMoved instanceof ItemBlockBasket) {
            if (destinationInventory instanceof InventoryCrafting || PrimalUtil.isSlotHotbarOrOffhand((int)slotIndex, (IInventory)destinationInventory)) {
                return true;
            }
            if (openContainer instanceof ContainerShulkerBox && destinationInventory instanceof ContainerLocalMenu) {
                return false;
            }
            if (BasketCaseConfig.basketsRestrictedToHotBar && destinationInventory instanceof InventoryPlayer) {
                return false;
            }
            if (!BasketCaseConfig.basketsAllowedInContainers && !(destinationInventory instanceof InventoryPlayer)) {
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPreToolTipRender(RenderTooltipEvent.Pre event) {
        this.mouseX = event.getX();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onToolTipRender(RenderTooltipEvent.PostText event) {
        ItemStackHandlerBasket basketInventory;
        ItemStack itemStack = event.getStack();
        if (Block.func_149634_a((Item)itemStack.func_77973_b()) instanceof BlockTileEntityBasket && GuiScreen.func_146272_n() && (basketInventory = (ItemStackHandlerBasket)((Object)itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null))) != null) {
            int spacer;
            int i;
            Minecraft minecraft = Minecraft.func_71410_x();
            int inventorySize = basketInventory.getSlots();
            int rows = 2;
            int columns = inventorySize / rows;
            int slotWidth = 17;
            int screenCenter = new ScaledResolution(minecraft).func_78326_a() / 2;
            int toolTipX = event.getX();
            int toolTipY = event.getY();
            int zLevel = 300;
            int toolTipW = event.getWidth();
            int inventoryWidth = columns * slotWidth;
            int leftEdge = this.mouseX > screenCenter ? toolTipX - 3 : toolTipX + toolTipW - inventoryWidth + 2;
            int rightEdge = leftEdge + inventoryWidth + 1;
            int bottomEdge = toolTipY - 6;
            int topEdge = bottomEdge - rows * slotWidth - 1;
            int backgroundColor = -267386864;
            int borderColorStart = 0x505000FF;
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            GuiUtils.drawGradientRect((int)zLevel, (int)leftEdge, (int)topEdge, (int)rightEdge, (int)bottomEdge, (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)zLevel, (int)(leftEdge - 1), (int)topEdge, (int)leftEdge, (int)bottomEdge, (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)zLevel, (int)rightEdge, (int)topEdge, (int)(rightEdge + 1), (int)bottomEdge, (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)zLevel, (int)leftEdge, (int)(topEdge - 1), (int)rightEdge, (int)topEdge, (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)zLevel, (int)leftEdge, (int)bottomEdge, (int)rightEdge, (int)(bottomEdge + 1), (int)backgroundColor, (int)backgroundColor);
            for (i = 0; i <= columns; ++i) {
                spacer = i * slotWidth;
                GuiUtils.drawGradientRect((int)zLevel, (int)(leftEdge + spacer), (int)topEdge, (int)(leftEdge + spacer + 1), (int)bottomEdge, (int)borderColorStart, (int)borderColorEnd);
            }
            for (i = 0; i <= rows; ++i) {
                spacer = i * slotWidth;
                GuiUtils.drawGradientRect((int)zLevel, (int)leftEdge, (int)(topEdge + spacer), (int)rightEdge, (int)(topEdge + spacer + 1), (int)borderColorStart, (int)borderColorEnd);
            }
            RenderHelper.func_74520_c();
            RenderItem renderItem = minecraft.func_175599_af();
            for (int i2 = 0; i2 < inventorySize; ++i2) {
                ItemStack itemInBasket = basketInventory.getStackInSlot(i2);
                int currentX = leftEdge + i2 % columns * slotWidth + 1;
                int currentY = topEdge + i2 / columns * slotWidth + 1;
                if (itemInBasket.func_190926_b()) continue;
                renderItem.field_77023_b = 300.0f;
                renderItem.func_180450_b(itemInBasket, currentX, currentY);
                renderItem.func_180453_a(event.getFontRenderer(), itemInBasket, currentX, currentY, null);
            }
            RenderHelper.func_74518_a();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            if (player.field_71070_bA != null && player.field_71070_bA instanceof ContainerBasket) {
                Container container = player.field_71070_bA;
                for (int i = 0; i < container.field_75151_b.size(); ++i) {
                    ItemStackHandlerBasket slotStackInv;
                    ItemStack slotStack = ((Slot)container.field_75151_b.get(i)).func_75211_c();
                    if (slotStack.func_190926_b() || !(slotStack.func_77973_b() instanceof ItemBlockBasket) || (slotStackInv = (ItemStackHandlerBasket)((Object)slotStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null))) == null) continue;
                    NBTTagCompound nbt = slotStackInv.serializeNBT();
                    BasketInventoryUpdate message = new BasketInventoryUpdate(i, nbt);
                    PacketHandler.network.sendTo((IMessage)message, player);
                }
            }
        }
    }

    @SubscribeEvent
    public void missingMappingBlockEvent(RegistryEvent.MissingMappings<Block> event) {
        ImmutableList mappings = event.getMappings();
        for (RegistryEvent.MissingMappings.Mapping mapping : mappings) {
            String missingName;
            switch (missingName = mapping.key.toString()) {
                case "basketcase:container_basket_small": {
                    if (BasketCaseConfig.allowWoodSpecificBaskets) {
                        PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_small_bark_oak", BlockRegistry.getBlocks());
                        break;
                    }
                    PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_small_generic", BlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:container_basket_medium": {
                    if (BasketCaseConfig.allowWoodSpecificBaskets) {
                        PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_medium_bark_oak", BlockRegistry.getBlocks());
                        break;
                    }
                    PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_medium_generic", BlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:container_basket_large": {
                    if (BasketCaseConfig.allowWoodSpecificBaskets) {
                        PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_large_bark_oak", BlockRegistry.getBlocks());
                        break;
                    }
                    PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_large_generic", BlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_oak": {
                    PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_oak", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_spruce": {
                    PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_spruce", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_birch": {
                    PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_birch", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_jungle": {
                    PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_jungle", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_acacia": {
                    PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_acacia", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_dark_oak": {
                    PrimalUtilReg.remapBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_dark_oak", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                }
            }
        }
    }

    @SubscribeEvent
    public void missingMappingItemEvent(RegistryEvent.MissingMappings<Item> event) {
        ImmutableList mappings = event.getMappings();
        for (RegistryEvent.MissingMappings.Mapping mapping : mappings) {
            String missingName;
            switch (missingName = mapping.key.toString()) {
                case "basketcase:container_basket_small": {
                    if (BasketCaseConfig.allowWoodSpecificBaskets) {
                        PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_small_bark_oak", BlockRegistry.getBlocks());
                        break;
                    }
                    PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_small_generic", BlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:container_basket_medium": {
                    if (BasketCaseConfig.allowWoodSpecificBaskets) {
                        PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_medium_bark_oak", BlockRegistry.getBlocks());
                        break;
                    }
                    PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_medium_generic", BlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:container_basket_large": {
                    if (BasketCaseConfig.allowWoodSpecificBaskets) {
                        PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_large_bark_oak", BlockRegistry.getBlocks());
                        break;
                    }
                    PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:basket_large_generic", BlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_oak": {
                    PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_oak", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_spruce": {
                    PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_spruce", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_birch": {
                    PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_birch", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_jungle": {
                    PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_jungle", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_acacia": {
                    PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_acacia", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:log_stripped_dark_oak": {
                    PrimalUtilReg.remapItemBlockTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:log_stripped_dark_oak", (LinkedHashSet)PrimalBlockRegistry.getBlocks());
                    break;
                }
                case "basketcase:item_wicker_small": {
                    if (BasketCaseConfig.allowWoodSpecificBaskets) {
                        PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:wicker_small_bark_oak", ItemRegistry.getItems());
                        break;
                    }
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:wicker_small_generic", ItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_wicker_medium": {
                    if (BasketCaseConfig.allowWoodSpecificBaskets) {
                        PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:wicker_medium_bark_oak", ItemRegistry.getItems());
                        break;
                    }
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:wicker_medium_generic", ItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_wicker_large": {
                    if (BasketCaseConfig.allowWoodSpecificBaskets) {
                        PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:wicker_large_bark_oak", ItemRegistry.getItems());
                        break;
                    }
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:wicker_large_generic", ItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_bark_strips": {
                    if (BasketCaseConfig.allowWoodSpecificBaskets) {
                        PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:bark_strips_oak", ItemRegistry.getItems());
                        break;
                    }
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:bark_strips_generic", ItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_twig": {
                    if (BasketCaseConfig.allowWoodSpecificBaskets) {
                        PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"basketcase:twig_oak", ItemRegistry.getItems());
                        break;
                    }
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:twig_generic", ItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_plant_fiber": {
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:plant_fiber", (LinkedHashSet)PrimalItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_cordage": {
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:twine", (LinkedHashSet)PrimalItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_bark_oak": {
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:bark_oak", (LinkedHashSet)PrimalItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_bark_spruce": {
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:bark_spruce", (LinkedHashSet)PrimalItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_bark_birch": {
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:bark_birch", (LinkedHashSet)PrimalItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_bark_jungle": {
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:bark_jungle", (LinkedHashSet)PrimalItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_bark_acacia": {
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:bark_acacia", (LinkedHashSet)PrimalItemRegistry.getItems());
                    break;
                }
                case "basketcase:item_bark_dark_oak": {
                    PrimalUtilReg.remapItemTo((RegistryEvent.MissingMappings.Mapping)mapping, (String)"primallib:bark_dark_oak", (LinkedHashSet)PrimalItemRegistry.getItems());
                }
            }
        }
    }
}

