/*
 * Decompiled with CFR 0.152.
 */
package com.daeruin.basketcase.blocks;

import com.daeruin.basketcase.BasketCase;
import com.daeruin.basketcase.config.BasketCaseConfig;
import com.daeruin.basketcase.inventory.ItemStackHandlerBasket;
import com.daeruin.basketcase.items.ItemBlockBasket;
import com.daeruin.basketcase.tileentity.TileEntityBasket;
import com.daeruin.primallib.IHasCustomItemBlock;
import com.daeruin.primallib.INeedsCustomModelReg;
import com.daeruin.primallib.blocks.BlockTileEntity;
import com.daeruin.primallib.util.PrimalUtilReg;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockTileEntityBasket
extends BlockTileEntity
implements IHasCustomItemBlock,
INeedsCustomModelReg {
    private final int numSlots;
    private final int maxStackSize;
    private final ResourceLocation guiTexture;
    private AxisAlignedBB AABB;

    BlockTileEntityBasket(String registryName, BasketSize basketSize) {
        super(registryName, Material.field_151580_n, 0.65f, true);
        this.func_149672_a(SoundType.field_185854_g);
        this.setHarvestLevel("axe", 0);
        this.numSlots = basketSize.numSlots;
        this.maxStackSize = basketSize.maxStackSize;
        this.guiTexture = new ResourceLocation("basketcase:textures/gui/basket.png");
        this.AABB = basketSize.AABB;
    }

    public void registerCustomModel() {
        Item item = Item.func_150898_a((Block)this);
        PrimalUtilReg.registerModel((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "normal"));
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public ResourceLocation getGuiTexture() {
        return this.guiTexture;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.AABB;
    }

    public Class getTileEntityClass() {
        return TileEntityBasket.class;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntityBasket createTileEntity(World world, IBlockState state) {
        TileEntityBasket tileEntity = new TileEntityBasket();
        tileEntity.initializeTileEntity(this.getNumSlots(), this.getMaxStackSize(), this.getGuiTexture());
        return tileEntity;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity tileEntity, ItemStack stack) {
        IItemHandler inventory;
        if (tileEntity != null && (inventory = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null && inventory instanceof ItemStackHandlerBasket) {
            this.spillInventoryContents(world, pos, tileEntity, inventory);
        }
        world.func_175698_g(pos);
        if (player.func_70093_af() || !BasketCaseConfig.hardcoreBasketBreakage) {
            BlockTileEntityBasket.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(state.func_177230_c()));
        }
    }

    private void spillInventoryContents(@Nonnull World world, @Nonnull BlockPos pos, TileEntity tileEntity, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStackCopy = inventory.getStackInSlot(i);
            if (itemStackCopy.func_190926_b() || itemStackCopy.func_190916_E() == 0) continue;
            tileEntity.func_145831_w().func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemStackCopy));
        }
    }

    public void pickUpBlock(World world, BlockPos pos, ItemStack itemStack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        ItemStack stack = new ItemStack((Block)this);
        if (tileEntity != null && tileEntity instanceof TileEntityBasket && !stack.func_190926_b()) {
            NBTTagCompound tileEntityInnerNBT = new NBTTagCompound();
            tileEntityInnerNBT = tileEntity.func_189515_b(tileEntityInnerNBT);
            NBTTagCompound blockEntityTagWrapper = new NBTTagCompound();
            blockEntityTagWrapper.func_74782_a("BlockEntityTag", (NBTBase)tileEntityInnerNBT);
            stack.func_77982_d(blockEntityTagWrapper);
            ItemStackHandlerBasket tileEntityCapability = (ItemStackHandlerBasket)((Object)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            ItemStackHandlerBasket itemStackCapability = (ItemStackHandlerBasket)((Object)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            if (tileEntityCapability != null && itemStackCapability != null) {
                NBTTagCompound inventoryNBT = tileEntityCapability.serializeNBT();
                itemStackCapability.deserializeNBT(inventoryNBT);
            }
        }
        super.pickUpBlock(world, pos, stack);
    }

    public boolean useBlock(World world, BlockPos pos, EntityPlayer player) {
        if (!BasketCaseConfig.basketsAreDecorativeOnly) {
            player.openGui((Object)BasketCase.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityBasket) {
            ItemStackHandlerBasket itemStackCapability = (ItemStackHandlerBasket)((Object)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            ItemStackHandlerBasket tileEntityCapability = (ItemStackHandlerBasket)((Object)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
            if (tileEntityCapability != null && itemStackCapability != null) {
                NBTTagCompound inventoryNBT = itemStackCapability.serializeNBT();
                tileEntityCapability.deserializeNBT(inventoryNBT);
            }
        }
    }

    public ItemBlock getItemBlock() {
        return new ItemBlockBasket((Block)this);
    }

    public static enum BasketSize {
        SMALL(4, BasketCaseConfig.maxStackSizeSmallBasket, new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.3125, 0.75)),
        MEDIUM(8, BasketCaseConfig.maxStackSizeMediumBasket, new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5625, 0.9375)),
        LARGE(12, BasketCaseConfig.maxStackSizeLargeBasket, new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375));

        private final int numSlots;
        private final int maxStackSize;
        private final AxisAlignedBB AABB;

        private BasketSize(int numSlots, int maxStackSize, AxisAlignedBB AABB) {
            this.numSlots = numSlots;
            this.maxStackSize = maxStackSize;
            this.AABB = AABB;
        }
    }
}

