/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic_view.config;

import net.minecraftforge.common.config.Config;

@Config(modid="dynview")
public class Configuration {
    @Config.Comment(value={"Dynamic chunk view distance settings"})
    public static DynamicChunk dynamicChunk = new DynamicChunk();

    public static class DynamicChunk {
        @Config.Comment(value={"The minimum chunk view distance allowed to use, set to what players should get at least. default: 4"})
        @Config.RangeInt(min=1, max=200)
        public int minChunkViewDist = 4;
        @Config.Comment(value={"The maximum chunk view distance allowed to use, set to the max which a player could benefit from. default: 20"})
        @Config.RangeInt(min=1, max=200)
        public int maxChunkViewDist = 20;
        @Config.Comment(value={"The average tick time to stabilize the chunk view distance around, setting it higher than 50ms is not advised, as after 50ms the tps will go below 20. default:40ms"})
        @Config.RangeInt(min=10, max=100)
        public int meanAvgTickTime = 45;
        @Config.Comment(value={"The update frequency of average server tick time checks to update view distances, default is every 30 seconds"})
        @Config.RangeInt(min=1, max=1000)
        public int viewDistanceUpdateRate = 30;
        @Config.Comment(value={"Whether to output log messages for actions done, its helpful to balance the other settings nicely."})
        public boolean logMessages = true;
    }
}

