/*
 * Decompiled with CFR 0.152.
 */
package com.malekire.multiblockmobs.particle;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public enum EobEnumParticleTypes {
    FLOWER("flower", 30, false);

    private final String particleName;
    private final int particleID;
    private final boolean shouldIgnoreRange;
    private final int argumentCount;
    private static final Map<Integer, EobEnumParticleTypes> PARTICLES;
    private static final Map<String, EobEnumParticleTypes> BY_NAME;

    private EobEnumParticleTypes(String particleNameIn, int particleIDIn, boolean shouldIgnoreRangeIn, int argumentCountIn) {
        this.particleName = particleNameIn;
        this.particleID = particleIDIn;
        this.shouldIgnoreRange = shouldIgnoreRangeIn;
        this.argumentCount = argumentCountIn;
    }

    private EobEnumParticleTypes(String particleNameIn, int particleIDIn, boolean shouldIgnoreRangeIn) {
        this(particleNameIn, particleIDIn, shouldIgnoreRangeIn, 0);
    }

    public static Set<String> getParticleNames() {
        return BY_NAME.keySet();
    }

    public String getParticleName() {
        return this.particleName;
    }

    public int getParticleID() {
        return this.particleID;
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    public boolean getShouldIgnoreRange() {
        return this.shouldIgnoreRange;
    }

    @Nullable
    public static EobEnumParticleTypes getParticleFromId(int particleId) {
        return PARTICLES.get(particleId);
    }

    @Nullable
    public static EobEnumParticleTypes getByName(String nameIn) {
        return BY_NAME.get(nameIn);
    }

    static {
        PARTICLES = Maps.newHashMap();
        BY_NAME = Maps.newHashMap();
        for (EobEnumParticleTypes enumparticletypes : EobEnumParticleTypes.values()) {
            PARTICLES.put(enumparticletypes.getParticleID(), enumparticletypes);
            BY_NAME.put(enumparticletypes.getParticleName(), enumparticletypes);
        }
    }
}

