/*
 * Decompiled with CFR 0.152.
 */
package com.malekire.multiblockmobs;

import com.google.common.base.Predicate;
import com.malekire.multiblockmobs.config.ModLocator;
import com.malekire.multiblockmobs.proxy.CommonProxy;
import com.malekire.multiblockmobs.util.CommandContainer;
import com.malekire.multiblockmobs.util.ModChecker;
import com.malekire.multiblockmobs.util.SoundEventContainer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

@Mod(modid="multiblockmobs", name="Malek's Multiblock Mobs", version="1.6", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="multiblockmobs")
public class Main {
    private static String file = "/multiblockmobs.mbm";
    public static Vector<Vector<BlockPattern>> blockPatternContainer = new Vector();
    public static Vector<BlockPattern> blockPatterns = new Vector();
    public static Vector<SoundEventContainer> soundEffects = new Vector();
    public static Vector<SoundEventContainer> music = new Vector();
    public static Vector<SoundEvent> soundEffectEvents = new Vector();
    public static Vector<SoundEvent> musicEvents = new Vector();
    public static Vector<ModLocator> entities = new Vector();
    public static Vector<CommandContainer> commands = new Vector();
    public static SoundEvent harvesterLaugh;
    static String filePath;
    public static final Logger logger;
    @Mod.Instance
    public static Main instance;
    @SidedProxy(clientSide="com.malekire.multiblockmobs.proxy.ClientProxy", serverSide="com.malekire.multiblockmobs.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final RegistryNamespaced<ResourceLocation, SoundEvent> REGISTRY;

    @Mod.EventHandler
    public static void PreInit(FMLPreInitializationEvent event) {
        ModChecker.checkMods();
        ModChecker.printSuccessMessage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) throws FileNotFoundException {
        filePath = Loader.instance().getConfigDir().toString();
        try {
            File myObj = new File(Loader.instance().getConfigDir() + file);
            if (!myObj.createNewFile()) {
                // empty if block
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File text = new File(Loader.instance().getConfigDir() + file);
        Scanner scnr = new Scanner(text);
        int lineNumber = 1;
        int x = 0;
        int y = 0;
        int z = 0;
        Vector<ModLocator> blocks = new Vector<ModLocator>();
        boolean init = false;
        boolean loc = false;
        Vector blockLocations = new Vector();
        while (true) {
            SoundEventContainer container;
            if (!scnr.hasNextLine()) {
                scnr.close();
                return;
            }
            String line = scnr.nextLine();
            if (line.contains("customCommand")) {
                commands.add(new CommandContainer(entities.size(), line.substring(line.indexOf(34) + 1, line.lastIndexOf(34))));
            }
            if (line.contains("soundEffectBoolean")) {
                container = new SoundEventContainer();
                container.Active = Boolean.valueOf(line.substring(line.indexOf(34) - 1, line.lastIndexOf(34)));
                ++lineNumber;
                line = scnr.nextLine();
                container.soundName = line.substring(line.indexOf(34) - 1, line.lastIndexOf(34));
                soundEffects.add(container);
            }
            if (line.contains("musicBoolean")) {
                container = new SoundEventContainer();
                container.Active = Boolean.valueOf(line.substring(line.indexOf(34) - 1, line.lastIndexOf(34)));
                ++lineNumber;
                line = scnr.nextLine();
                container.soundName = line.substring(line.indexOf(34) - 1, line.lastIndexOf(34));
                music.add(container);
            }
            if (line.contains("Dimensions")) {
                x = Character.getNumericValue(line.charAt(line.indexOf("x = ") + 4));
                y = Character.getNumericValue(line.charAt(line.indexOf("y = ") + 4));
                z = Character.getNumericValue(line.charAt(line.indexOf("z = ") + 4));
            }
            if (line.contains("!startInit")) {
                init = true;
            } else if (line.contains("!endInit")) {
                init = false;
            } else if (init) {
                while (!line.contains("!endInit")) {
                    String modid = line.substring(0, line.indexOf(58));
                    String thing = line.substring(line.indexOf(58) + 1, line.indexOf(" "));
                    String character = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
                    blocks.add(new ModLocator(modid, thing, character));
                    ++lineNumber;
                    line = scnr.nextLine();
                    init = false;
                }
            }
            if (line.contains("!startLoc")) {
                loc = true;
            } else if (line.contains("!stopLoc")) {
                loc = false;
            } else if (loc) {
                for (int i3 = 1; i3 <= z; ++i3) {
                    Vector<String> blockTemp = new Vector<String>();
                    int i2 = 1;
                    while (i2 <= y) {
                        if (line.contains("[")) {
                            blockTemp.add(line.substring(line.indexOf(34) + 1, line.indexOf(34) + x + 1));
                            ++i2;
                        }
                        line = scnr.nextLine();
                        ++lineNumber;
                    }
                    blockLocations.add(new Vector(blockTemp));
                    blockTemp.clear();
                }
                loc = false;
            }
            if (line.contains("!entityStart")) {
                ++lineNumber;
                line = scnr.nextLine();
                entities.add(new ModLocator(line.substring(line.indexOf(34) + 1, line.indexOf(58)), line.substring(line.indexOf(58) + 1, line.lastIndexOf(34)), ""));
            }
            ++lineNumber;
            if (!line.contains("!endMultiblockMob")) continue;
            String[][] tempBlockLoc = new String[z][y];
            for (int i = 0; i < blockLocations.size(); ++i) {
                for (int i2 = 0; i2 < ((Vector)blockLocations.get(i)).size(); ++i2) {
                    tempBlockLoc[i][i2] = (String)((Vector)blockLocations.get(i)).get(i2);
                }
                FactoryBlockPattern patterntest = FactoryBlockPattern.func_177660_a().func_177659_a(tempBlockLoc[i]);
                for (int i3 = 0; i3 < blocks.size(); ++i3) {
                    patterntest.func_177662_a(((ModLocator)blocks.get((int)i3)).character.charAt(0), Main.getBlock(((ModLocator)blocks.get((int)i3)).modID, ((ModLocator)blocks.get((int)i3)).thing));
                }
                blockPatterns.add(patterntest.func_177661_b());
                patterntest = null;
            }
            blockPatternContainer.add(new Vector<BlockPattern>(blockPatterns));
            blockPatterns.clear();
            blockLocations.clear();
            blocks.clear();
        }
    }

    public static Predicate<BlockWorldState> getBlock(String modid, String block) {
        return BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modid, block)))));
    }

    @Mod.EventHandler
    public static void PostInit(FMLPostInitializationEvent event) {
        for (CommandContainer s : commands) {
            System.out.println(s.place);
            System.out.println(s.command);
        }
    }

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        int i;
        IForgeRegistry reg = event.getRegistry();
        for (i = 0; i < soundEffects.size(); ++i) {
            if (!Main.soundEffects.get((int)i).Active) continue;
            Main.soundEffects.get((int)i).soundEvent = Main.registerSoundEffect((IForgeRegistry<SoundEvent>)reg, Main.soundEffects.get((int)i).soundName);
        }
        for (i = 0; i < music.size(); ++i) {
            if (!Main.music.get((int)i).Active) continue;
            Main.music.get((int)i).soundEvent = Main.registerSoundEffect((IForgeRegistry<SoundEvent>)reg, Main.music.get((int)i).soundName);
        }
    }

    public static SoundEvent registerSoundEffect(IForgeRegistry<SoundEvent> reg, String name) {
        ResourceLocation location = new ResourceLocation("multiblockmobs", name);
        SoundEvent event = (SoundEvent)new SoundEvent(location).setRegistryName(filePath + "/Malek's Multiblock Mobs Resources" + name);
        reg.register((IForgeRegistryEntry)event);
        return event;
    }

    public static SoundEvent registerMusic(IForgeRegistry<SoundEvent> reg, String name) {
        ResourceLocation location = new ResourceLocation("multiblockmobs", name);
        SoundEvent event = (SoundEvent)new SoundEvent(location).setRegistryName(filePath + "/Malek's Multiblock Mobs Resources" + name);
        reg.register((IForgeRegistryEntry)event);
        return event;
    }

    static {
        logger = (Logger)LogManager.getFormatterLogger((String)"multiblockmobs");
        REGISTRY = GameData.getWrapper(SoundEvent.class);
    }
}

