/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.orestages.compat.crt;

import com.google.common.collect.Lists;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.darkhax.orestages.api.OreTiersAPI;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.math.NumberUtils;

public class ActionAddReplacement
implements IAction {
    private final String stage;
    private final List<IBlockState> originals;
    private final List<IBlockState> replacements;
    private final boolean allowDefaultDrop;

    public ActionAddReplacement(String stage, String original, String replacement, boolean defDrop) {
        this(stage, (List<IBlockState>)ActionAddReplacement.getState(original), (List<IBlockState>)ActionAddReplacement.getState(replacement), defDrop);
    }

    public ActionAddReplacement(String stage, IIngredient original, boolean defDrop) {
        this(stage, original, null, defDrop);
    }

    public ActionAddReplacement(String stage, IIngredient original, IItemStack replacement, boolean defDrop) {
        this(stage, ActionAddReplacement.getStatesFromIngredient(original), replacement != null ? ActionAddReplacement.getStatesFromStack(CraftTweakerMC.getItemStack((IItemStack)replacement)) : Arrays.asList(Blocks.field_150348_b.func_176223_P()), defDrop);
    }

    public ActionAddReplacement(String stage, List<IBlockState> originals, List<IBlockState> replacements, boolean defDrop) {
        this.stage = stage;
        this.originals = originals;
        this.replacements = replacements;
        this.allowDefaultDrop = defDrop;
    }

    public void apply() {
        if (this.originals.isEmpty()) {
            throw new IllegalArgumentException("No valid blocks to replace!");
        }
        if (this.replacements.isEmpty()) {
            throw new IllegalArgumentException("No valid blocks to replace with!");
        }
        for (IBlockState original : this.originals) {
            for (IBlockState replacement : this.replacements) {
                if (original == replacement) {
                    throw new IllegalArgumentException("You can not replace a block with itself!");
                }
                OreTiersAPI.addReplacement(this.stage, original, replacement, this.allowDefaultDrop);
            }
        }
    }

    public String describe() {
        return String.format("Adding a replacement for stage %s. %s will become %s", this.stage, ActionAddReplacement.listToString(this.originals), ActionAddReplacement.listToString(this.replacements));
    }

    private static String listToString(List<?> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    private static List<IBlockState> getStatesFromIngredient(IIngredient original) {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        if (original != null) {
            for (ItemStack stack : CraftTweakerMC.getItemStacks((List)original.getItems())) {
                states.addAll(ActionAddReplacement.getStatesFromStack(stack));
            }
        }
        return states;
    }

    private static List<IBlockState> getStatesFromStack(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == Blocks.field_150450_ax) {
            return Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150450_ax.func_176223_P(), Blocks.field_150439_ay.func_176223_P()});
        }
        if (stack.func_77960_j() == Short.MAX_VALUE) {
            return block.func_176194_O().func_177619_a();
        }
        return Lists.newArrayList((Object[])new IBlockState[]{ActionAddReplacement.getStateFromStack(stack)});
    }

    private static IBlockState getStateFromStack(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        return block != null ? block.func_176203_a(stack.func_77960_j()) : Blocks.field_150348_b.func_176223_P();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NonNullList<IBlockState> getState(String string) {
        NonNullList states = NonNullList.func_191196_a();
        String[] parts = string.split(":");
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Invalid block ID. Format is modid:blockid:meta The meta is optional!");
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0], parts[1]));
        if (block == null) {
            throw new IllegalArgumentException("No block found for " + parts[0] + ":" + parts[1]);
        }
        int meta = 0;
        if (parts.length == 3) {
            if (!NumberUtils.isCreatable((String)parts[2])) {
                if (!"*".equalsIgnoreCase(parts[2])) throw new IllegalArgumentException("Invalid meta for " + string + ". " + parts[2] + " is not a valid meta!");
                meta = Short.MAX_VALUE;
            } else {
                meta = Integer.parseInt(parts[2]);
            }
        }
        if (meta == Short.MAX_VALUE) {
            states.addAll((Collection)block.func_176194_O().func_177619_a());
            return states;
        } else {
            states.add((Object)block.func_176203_a(meta));
        }
        return states;
    }
}

