/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.orestages.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.darkhax.orestages.OreStages;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Tuple;

public final class OreTiersAPI {
    private static final List<IBlockState> RELEVANT_STATES = new ArrayList<IBlockState>();
    public static final Map<IBlockState, Tuple<String, IBlockState>> STATE_MAP = new HashMap<IBlockState, Tuple<String, IBlockState>>();
    public static final Map<String, String> REPLACEMENT_IDS = new HashMap<String, String>();
    public static final List<IBlockState> NON_DEFAULTING = new ArrayList<IBlockState>();

    public static void addReplacement(@Nonnull String stage, @Nonnull Block original, int originalMeta, @Nonnull Block replacement, int replacementMeta, boolean defAllow) {
        OreTiersAPI.addReplacement(stage, original.func_176203_a(originalMeta), replacement.func_176203_a(replacementMeta), defAllow);
    }

    public static void addReplacement(@Nonnull String stage, @Nonnull Block original, @Nonnull Block replacement, boolean defAllow) {
        OreTiersAPI.addReplacement(stage, original.func_176223_P(), replacement.func_176223_P(), defAllow);
    }

    public static void addReplacement(@Nonnull String stage, @Nonnull IBlockState original, @Nonnull IBlockState replacement, boolean defAllow) {
        if (OreTiersAPI.hasReplacement(original)) {
            OreStages.LOG.info(String.format("Attempted to register duplicate replacement for %s on stage %s. It will be replaced.", original.toString(), stage), new Object[0]);
        }
        STATE_MAP.put(original, (Tuple<String, IBlockState>)new Tuple((Object)stage, (Object)replacement));
        OreTiersAPI.addRelevantState(original);
        OreTiersAPI.addRelevantState(replacement);
        REPLACEMENT_IDS.put(original.func_177230_c().getRegistryName().toString(), replacement.func_177230_c().getRegistryName().toString());
        if (defAllow) {
            NON_DEFAULTING.add(original);
        }
    }

    public static void removeReplacement(IBlockState state) {
        STATE_MAP.remove(state);
    }

    public static boolean hasReplacement(@Nonnull IBlockState state) {
        return STATE_MAP.containsKey(state);
    }

    public static Set<IBlockState> getStatesToReplace() {
        return STATE_MAP.keySet();
    }

    public static List<IBlockState> getRelevantStates() {
        return RELEVANT_STATES;
    }

    @Nullable
    public static Tuple<String, IBlockState> getStageInfo(@Nonnull IBlockState state) {
        return STATE_MAP.get(state);
    }

    private static void addRelevantState(@Nonnull IBlockState state) {
        if (!RELEVANT_STATES.contains(state)) {
            RELEVANT_STATES.add(state);
        }
    }
}

