/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMaps;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.IntSummaryStatistics;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import mezz.jei.search.Edge;
import mezz.jei.util.Substring;
import org.apache.commons.lang3.ArrayUtils;

public class Node<T> {
    @Nullable
    private T[] data = null;
    @Nullable
    private Char2ObjectMap<Edge<T>> edges = null;
    @Nullable
    private Node<T> suffix = null;

    Node() {
    }

    void getData(Set<T> ret) {
        if (this.data != null) {
            ret.addAll(Arrays.asList(this.data));
        }
        if (this.edges != null) {
            for (Edge e : this.edges.values()) {
                e.getDest().getData(ret);
            }
        }
    }

    boolean addRef(T index) {
        if (this.contains(index)) {
            return false;
        }
        this.addValue(index);
        Node<T> iter = this.suffix;
        while (iter != null && !iter.contains(index)) {
            iter.addValue(index);
            iter = iter.suffix;
        }
        return true;
    }

    protected boolean contains(T index) {
        if (this.data == null) {
            return false;
        }
        for (T id : this.data) {
            if (id != index) continue;
            return true;
        }
        return false;
    }

    protected void addEdge(Edge<T> e) {
        if (this.edges == null) {
            this.edges = Char2ObjectMaps.singleton((char)e.charAt(0), e);
        } else if (this.edges instanceof Char2ObjectMaps.Singleton) {
            Char2ObjectMap.Entry existingEdge = (Char2ObjectMap.Entry)this.edges.char2ObjectEntrySet().iterator().next();
            this.edges = new Char2ObjectArrayMap(2);
            this.edges.put(existingEdge.getCharKey(), existingEdge.getValue());
            this.edges.put(e.charAt(0), e);
        } else {
            this.edges.put(e.charAt(0), e);
        }
    }

    @Nullable
    Edge<T> getEdge(char ch) {
        return this.edges == null ? null : (Edge)this.edges.get(ch);
    }

    @Nullable
    Edge<T> getEdge(Substring substring) {
        if (substring.isEmpty()) {
            return null;
        }
        return this.edges == null ? null : (Edge)this.edges.get(substring.charAt(0));
    }

    @Nullable
    Node<T> getSuffix() {
        return this.suffix;
    }

    void setSuffix(Node<T> suffix) {
        this.suffix = suffix;
    }

    protected void addValue(T index) {
        this.data = this.data == null ? new Object[]{index} : ArrayUtils.add((Object[])this.data, index);
    }

    public String toString() {
        return "Node: size:" + (this.data == null ? "nil" : Integer.valueOf(this.data.length)) + " Edges: " + this.edges;
    }

    public IntSummaryStatistics nodeSizeStats() {
        return this.nodeSizes().summaryStatistics();
    }

    private IntStream nodeSizes() {
        return IntStream.concat(IntStream.of(this.data == null ? 0 : this.data.length), this.edges == null ? IntStream.of(0) : this.edges.values().stream().flatMapToInt(e -> super.nodeSizes()));
    }

    public String nodeEdgeStats() {
        IntSummaryStatistics edgeCounts = this.nodeEdgeCounts().summaryStatistics();
        IntSummaryStatistics edgeLengths = this.nodeEdgeLengths().summaryStatistics();
        return "Edge counts: " + edgeCounts + "\nEdge lengths: " + edgeLengths;
    }

    private IntStream nodeEdgeCounts() {
        return this.edges == null ? IntStream.of(new int[0]) : IntStream.concat(IntStream.of(this.edges.size()), this.edges.values().stream().map(Edge::getDest).flatMapToInt(Node::nodeEdgeCounts));
    }

    private IntStream nodeEdgeLengths() {
        return this.edges == null ? IntStream.of(new int[0]) : IntStream.concat(this.edges.values().stream().mapToInt(Substring::length), this.edges.values().stream().map(Edge::getDest).flatMapToInt(Node::nodeEdgeLengths));
    }

    public void printTree(PrintWriter out, boolean includeSuffixLinks) {
        out.println("digraph {");
        out.println("\trankdir = LR;");
        out.println("\tordering = out;");
        out.println("\tedge [arrowsize=0.4,fontsize=10]");
        out.println("\t" + Node.nodeId(this) + " [label=\"\",style=filled,fillcolor=lightgrey,shape=circle,width=.1,height=.1];");
        out.println("//------leaves------");
        this.printLeaves(out);
        out.println("//------internal nodes------");
        this.printInternalNodes(this, out);
        out.println("//------edges------");
        this.printEdges(out);
        if (includeSuffixLinks) {
            out.println("//------suffix links------");
            this.printSLinks(out);
        }
        out.println("}");
    }

    private void printLeaves(PrintWriter out) {
        if (this.edges == null) {
            out.println("\t" + Node.nodeId(this) + " [label=\"" + this.data + "\",shape=point,style=filled,fillcolor=lightgrey,shape=circle,width=.07,height=.07]");
        } else {
            for (Edge edge : this.edges.values()) {
                super.printLeaves(out);
            }
        }
    }

    private void printInternalNodes(Node<T> root, PrintWriter out) {
        if (this != root && this.edges != null) {
            out.println("\t" + Node.nodeId(this) + " [label=\"" + this.data + "\",style=filled,fillcolor=lightgrey,shape=circle,width=.07,height=.07]");
        }
        if (this.edges != null) {
            for (Edge edge : this.edges.values()) {
                super.printInternalNodes(root, out);
            }
        }
    }

    private void printEdges(PrintWriter out) {
        if (this.edges != null) {
            for (Edge edge : this.edges.values()) {
                Node child = edge.getDest();
                out.println("\t" + Node.nodeId(this) + " -> " + Node.nodeId(child) + " [label=\"" + edge.commit() + "\",weight=10]");
                super.printEdges(out);
            }
        }
    }

    private void printSLinks(PrintWriter out) {
        if (this.suffix != null) {
            out.println("\t" + Node.nodeId(this) + " -> " + Node.nodeId(this.suffix) + " [label=\"\",weight=0,style=dotted]");
        }
        if (this.edges != null) {
            for (Edge edge : this.edges.values()) {
                super.printSLinks(out);
            }
        }
    }

    private static <T> String nodeId(Node<T> node) {
        return "node" + Integer.toHexString(node.hashCode()).toUpperCase();
    }

    public static class Root<T>
    extends Node<T> {
        @Override
        protected boolean contains(T value) {
            return true;
        }

        @Override
        protected void addValue(T index) {
        }
    }
}

