/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.unoriginal.ancientbeasts.init.ModSounds;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTornado
extends Entity {
    private static final DataParameter<Integer> LIFTED = EntityDataManager.func_187226_a(EntityTornado.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityLivingBase caster;
    private int lifeticks = 50;
    private int liftTime;
    private int maxLiftTime = 30;
    private UUID casterUuid;
    private boolean isAboutToVanish;

    public EntityTornado(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 2.0f);
    }

    public EntityTornado(World worldIn, double x, double y, double z, float rotationYaw, EntityLivingBase casterIn) {
        this(worldIn);
        this.setCaster(casterIn);
        this.field_70177_z = rotationYaw * 57.295776f;
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LIFTED, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.casterUuid = compound.func_186857_a("OwnerUUID");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.casterUuid != null) {
            compound.func_186854_a("OwnerUUID", this.casterUuid);
        }
    }

    public void setCaster(@Nullable EntityLivingBase entityLivingBase) {
        this.casterUuid = entityLivingBase == null ? null : entityLivingBase.func_110124_au();
    }

    @Nullable
    public EntityLivingBase getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.casterUuid)) instanceof EntityLivingBase) {
            this.caster = (EntityLivingBase)entity;
        }
        return this.caster;
    }

    public void func_70071_h_() {
        Entity lifted;
        super.func_70071_h_();
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        --this.lifeticks;
        if (this.lifeticks <= 0 && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        if ((lifted = this.getLiftedEntity()) == null && !this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            List list = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_186662_g((double)0.8f));
            EntityItem closestItem = null;
            for (Object item : list) {
                if (((EntityItem)item).field_70122_E && closestItem != null) {
                    this.func_70032_d((Entity)closestItem);
                    this.func_70032_d((Entity)item);
                }
                closestItem = item;
            }
            if (closestItem != null) {
                this.setLifted(closestItem.func_145782_y());
                this.maxLiftTime = 30 + this.field_70146_Z.nextInt(20);
            }
            List list1 = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g((double)0.8f));
            for (EntityLivingBase entityLivingBase : list1) {
                if (entityLivingBase == null || !entityLivingBase.field_70122_E || entityLivingBase == this.getCaster()) continue;
                this.setLifted(entityLivingBase.func_145782_y());
                entityLivingBase.field_70133_I = true;
            }
        }
        if (lifted != null && this.liftTime >= 0) {
            ++this.liftTime;
            float resist = 1.0f;
            if (lifted instanceof EntityLivingBase) {
                resist = (float)MathHelper.func_151237_a((double)(1.0 - ((EntityLivingBase)lifted).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()), (double)0.0, (double)1.0);
            }
            float radius = 1.0f + (float)this.liftTime * 0.05f;
            if (lifted instanceof EntityItem) {
                radius = 0.2f + (float)this.liftTime * 0.025f;
            }
            float angle = (float)this.liftTime * -0.25f;
            double extraX = this.field_70165_t + (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle))));
            double extraZ = this.field_70161_v + (double)(radius * MathHelper.func_76134_b((float)angle));
            double d0 = (extraX - lifted.field_70165_t) * (double)resist;
            double d1 = (extraZ - lifted.field_70161_v) * (double)resist;
            lifted.func_70024_g(d0, 0.1 * (double)resist, d1);
            lifted.field_70160_al = true;
            if (this.liftTime > this.maxLiftTime) {
                this.setLifted(0);
                this.liftTime = -20;
                this.maxLiftTime = 30 + this.field_70146_Z.nextInt(30);
            }
        } else if (this.liftTime < 0) {
            ++this.liftTime;
        }
        if (this.lifeticks == 49) {
            this.func_184185_a(ModSounds.TORNADO_AMBIENT, 1.0f, 1.0f);
        }
    }

    public boolean isLifting() {
        return (Integer)this.field_70180_af.func_187225_a(LIFTED) != 0;
    }

    @Nullable
    public Entity getLiftedEntity() {
        if (!this.isLifting()) {
            return null;
        }
        return this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(LIFTED)).intValue());
    }

    private void setLifted(int time) {
        this.field_70180_af.func_187227_b(LIFTED, (Object)time);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.isAboutToVanish = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getAnimationProgress(float partialTicks) {
        if (!this.isAboutToVanish) {
            return 0.0f;
        }
        int i = this.lifeticks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - partialTicks) / 20.0f;
    }
}

