/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.init.ModParticles;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRiftedEnderman
extends EntityMob {
    private static final UUID ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier ATTACKING_SPEED_BOOST = new AttributeModifier(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", (double)0.15f, 0).func_111168_a(false);
    private static final Set<Block> CARRIABLE_BLOCKS = Sets.newIdentityHashSet();
    private static final DataParameter<Optional<IBlockState>> CARRIED_BLOCK = EntityDataManager.func_187226_a(EntityRiftedEnderman.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(EntityRiftedEnderman.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ARMORED = EntityDataManager.func_187226_a(EntityRiftedEnderman.class, (DataSerializer)DataSerializers.field_187192_b);
    private int lastCreepySound;
    private int armoredTicks;
    private int armoredCooldown;
    private int armorWeakTicks;
    private int laserTicks;
    private int laserCD;
    private static final DataParameter<Integer> LASER_TARGET = EntityDataManager.func_187226_a(EntityRiftedEnderman.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityLivingBase laserTarget;
    public static final ResourceLocation LOOT = new ResourceLocation("ancientbeasts", "entities/Rifted_Enderman");

    public EntityRiftedEnderman(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 2.9f);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new AIPlaceBlock(this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new AITakeBlock(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIFindPlayer(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityEnderman.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0 * AncientBeastsConfig.GlobalHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0 * AncientBeastsConfig.GlobalDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(28.0);
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (entitylivingbaseIn == null) {
            this.field_70180_af.func_187227_b(SCREAMING, (Object)Boolean.FALSE);
            iattributeinstance.func_111124_b(ATTACKING_SPEED_BOOST);
        } else {
            this.field_70180_af.func_187227_b(SCREAMING, (Object)Boolean.TRUE);
            if (!iattributeinstance.func_180374_a(ATTACKING_SPEED_BOOST)) {
                iattributeinstance.func_111121_a(ATTACKING_SPEED_BOOST);
            }
        }
        if (this.armoredCooldown <= 0 && !this.isArmored()) {
            this.setArmored(2);
            this.armoredTicks = 4000;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARRIED_BLOCK, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SCREAMING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(ARMORED, (Object)0);
        this.field_70180_af.func_187214_a(LASER_TARGET, (Object)0);
    }

    public void playEndermanSound() {
        if (this.field_70173_aa >= this.lastCreepySound + 400) {
            this.lastCreepySound = this.field_70173_aa;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, SoundEvents.field_187533_aW, this.func_184176_by(), 2.5f, 1.0f, false);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SCREAMING.equals(key) && this.isScreaming() && this.field_70170_p.field_72995_K) {
            this.playEndermanSound();
        }
        if (LASER_TARGET.equals(key)) {
            this.laserTarget = null;
        }
        super.func_184206_a(key);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        IBlockState iblockstate = this.getHeldBlockState();
        if (iblockstate != null) {
            compound.func_74777_a("carried", (short)Block.func_149682_b((Block)iblockstate.func_177230_c()));
            compound.func_74777_a("carriedData", (short)iblockstate.func_177230_c().func_176201_c(iblockstate));
        }
        if (compound.func_74764_b("WeakTicks")) {
            this.armorWeakTicks = compound.func_74762_e("WeakTicks");
        }
        if (compound.func_74764_b("ArmorTicks")) {
            this.armoredTicks = compound.func_74762_e("ArmorTicks");
        }
        if (compound.func_74764_b("ArmorCooldown")) {
            this.armoredCooldown = compound.func_74762_e("ArmorCooldown");
        }
        if (compound.func_74764_b("LaserCooldown")) {
            this.laserCD = compound.func_74762_e("LaserCooldown");
        }
        if (compound.func_74764_b("LaserTicks")) {
            this.laserTicks = compound.func_74762_e("LaserTicks");
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        IBlockState iblockstate = compound.func_150297_b("carried", 8) ? Block.func_149684_b((String)compound.func_74779_i("carried")).func_176203_a(compound.func_74765_d("carriedData") & 0xFFFF) : Block.func_149729_e((int)compound.func_74765_d("carried")).func_176203_a(compound.func_74765_d("carriedData") & 0xFFFF);
        iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() == Material.field_151579_a) {
            iblockstate = null;
        }
        this.setHeldBlockState(iblockstate);
        compound.func_74768_a("WeakTicks", this.armorWeakTicks);
        compound.func_74768_a("ArmorTicks", this.armoredTicks);
        compound.func_74768_a("ArmorCooldown", this.armoredCooldown);
        compound.func_74768_a("LaserCooldown", this.laserCD);
        compound.func_74768_a("LaserTicks", this.laserTicks);
    }

    private boolean shouldAttackPlayer(EntityPlayer player) {
        ItemStack itemstack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        return itemstack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150423_aK) && this.func_70685_l((Entity)player) && player.func_70685_l((Entity)this);
    }

    public float func_70047_e() {
        return 2.55f;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(ModParticles.RIFT, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        if (this.isVulnerable()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
        }
        if (this.isArmored() && !this.field_70170_p.field_72995_K) {
            if (--this.armoredTicks <= 0) {
                this.setArmored(0);
                this.armoredCooldown = 3000 + this.field_70146_Z.nextInt(3000);
            }
            if (this.field_70173_aa % (300 + this.field_70146_Z.nextInt(300)) == 0 && !this.isVulnerable()) {
                this.armorWeakTicks = 50;
                if (this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az()) && this.func_70638_az().func_70685_l((Entity)this)) {
                    this.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 50, 0, false, false));
                }
            }
        }
        if (!this.isArmored() && !this.field_70170_p.field_72995_K && this.armoredTicks > 0) {
            this.armoredCooldown = 3000 + this.field_70146_Z.nextInt(3000);
            this.armoredTicks = 0;
        }
        if (this.armoredCooldown > 0) {
            --this.armoredCooldown;
        }
        if (this.armorWeakTicks > 0) {
            --this.armorWeakTicks;
        }
        if (this.laserCD > 0) {
            --this.laserCD;
        }
        this.field_70703_bu = false;
        if (this.func_70638_az() != null && !this.field_70170_p.field_72995_K && this.func_70685_l((Entity)this.func_70638_az()) && this.func_70068_e((Entity)this.func_70638_az()) > 9.0 && this.func_70068_e((Entity)this.func_70638_az()) < AncientBeastsConfig.RELaserRange && this.isArmored() && this.laserTicks <= 0 && this.laserCD <= 0) {
            this.laserTicks = 80;
            this.armorWeakTicks = 120;
            if (this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az()) && this.func_70638_az().func_70685_l((Entity)this)) {
                this.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 120, 0, false, false));
            }
            this.setLaserTarget(this.func_70638_az().func_145782_y());
        }
        if (this.hasLaserTarget() && !this.field_70170_p.field_72995_K) {
            EntityLivingBase entitylivingbase = this.getLaserTarget();
            if (entitylivingbase != null && this.field_70170_p.field_72995_K) {
                this.func_70671_ap().func_75651_a((Entity)entitylivingbase, (float)this.func_184649_cE(), (float)this.func_70646_bf());
            }
            if (--this.laserTicks > 0 && entitylivingbase != null) {
                if (this.func_70685_l((Entity)entitylivingbase) && this.field_70173_aa % 5 == 0) {
                    entitylivingbase.func_70097_a(EntityDamageSource.func_76358_a((EntityLivingBase)this).func_82726_p(), 0.5f * (float)AncientBeastsConfig.GlobalDamageMultiplier);
                    if (!entitylivingbase.func_184585_cz()) {
                        entitylivingbase.func_70015_d(1);
                    }
                }
                this.field_70159_w *= 0.0;
                this.field_70179_y *= 0.0;
            } else if (entitylivingbase != null && (this.laserCD <= 0 || !this.func_70685_l((Entity)entitylivingbase) || this.field_70737_aN != 0 || this.func_70068_e((Entity)entitylivingbase) > AncientBeastsConfig.RELaserRange)) {
                this.laserCD = 600 + this.field_70146_Z.nextInt(400);
                this.laserTicks = 0;
                this.setLaserTarget(0);
            }
            this.field_70177_z = this.field_70759_as;
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        if (this.func_70026_G() && !this.isArmored()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        super.func_70619_bc();
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187531_aU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        IBlockState iblockstate = this.getHeldBlockState();
        if (iblockstate != null) {
            Item item = Item.func_150898_a((Block)iblockstate.func_177230_c());
            int i = item.func_77614_k() ? iblockstate.func_177230_c().func_176201_c(iblockstate) : 0;
            this.func_70099_a(new ItemStack(item, 1, i), 0.0f);
        }
    }

    public void setHeldBlockState(@Nullable IBlockState state) {
        this.field_70180_af.func_187227_b(CARRIED_BLOCK, (Object)Optional.fromNullable((Object)state));
    }

    @Nullable
    public IBlockState getHeldBlockState() {
        return (IBlockState)((Optional)this.field_70180_af.func_187225_a(CARRIED_BLOCK)).orNull();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            if (!this.isArmored()) {
                for (int i = 0; i < 64; ++i) {
                    if (!this.teleportRandomly()) continue;
                    return true;
                }
                return false;
            }
            return super.func_70097_a(source, amount * 0.1f);
        }
        if (this.isArmored()) {
            if (this.isVulnerable()) {
                int damage = (Integer)this.field_70180_af.func_187225_a(ARMORED);
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                this.setArmored(damage - 1);
                this.armorWeakTicks = 0;
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                if (this.getLaserTarget() != null) {
                    this.func_70097_a(source, 20.0f);
                    this.setArmored(0);
                }
            } else {
                amount *= 0.1f;
            }
        }
        boolean flag = super.func_70097_a(source, amount);
        if (source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0 && !this.isArmored()) {
            this.teleportRandomly();
        }
        return flag;
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    public boolean isArmored() {
        return (Integer)this.field_70180_af.func_187225_a(ARMORED) > 0;
    }

    public int getArmorValue() {
        return (Integer)this.field_70180_af.func_187225_a(ARMORED);
    }

    public void setArmored(int armored) {
        this.field_70180_af.func_187227_b(ARMORED, (Object)armored);
    }

    public boolean isVulnerable() {
        return this.armorWeakTicks > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return this.isVulnerable() || this.hasLaserTarget() ? 0xF000F0 : super.func_70070_b();
    }

    public float func_70013_c() {
        return this.isVulnerable() || this.hasLaserTarget() ? 1.0f : super.func_70013_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 6) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.END_ROD, this.field_70165_t + 0.55 - (double)(this.field_70146_Z.nextFloat() * 0.1f), this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.55 - (double)(this.field_70146_Z.nextFloat() * 0.1f), this.field_70161_v + 0.55 - (double)(this.field_70146_Z.nextFloat() * 0.1f), this.field_70146_Z.nextGaussian() * 0.05, this.field_70146_Z.nextGaussian() * 0.05, this.field_70146_Z.nextGaussian() * 0.05, new int[0]);
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_184595_k(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            world.func_175688_a(ModParticles.RIFT, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        this.func_70661_as().func_75499_g();
        return true;
    }

    private void setLaserTarget(int entityId) {
        this.field_70180_af.func_187227_b(LASER_TARGET, (Object)entityId);
    }

    public boolean hasLaserTarget() {
        return (Integer)this.field_70180_af.func_187225_a(LASER_TARGET) != 0;
    }

    @Nullable
    public EntityLivingBase getLaserTarget() {
        if (!this.hasLaserTarget()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.laserTarget != null) {
                return this.laserTarget;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(LASER_TARGET)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.laserTarget = (EntityLivingBase)entity;
                return this.laserTarget;
            }
            return null;
        }
        return this.func_70638_az();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_71093_bK == 0;
    }

    static {
        CARRIABLE_BLOCKS.add((Block)Blocks.field_150349_c);
        CARRIABLE_BLOCKS.add(Blocks.field_150346_d);
        CARRIABLE_BLOCKS.add((Block)Blocks.field_150354_m);
        CARRIABLE_BLOCKS.add(Blocks.field_150351_n);
        CARRIABLE_BLOCKS.add((Block)Blocks.field_150327_N);
        CARRIABLE_BLOCKS.add((Block)Blocks.field_150328_O);
        CARRIABLE_BLOCKS.add((Block)Blocks.field_150338_P);
        CARRIABLE_BLOCKS.add((Block)Blocks.field_150337_Q);
        CARRIABLE_BLOCKS.add(Blocks.field_150335_W);
        CARRIABLE_BLOCKS.add((Block)Blocks.field_150434_aF);
        CARRIABLE_BLOCKS.add(Blocks.field_150435_aG);
        CARRIABLE_BLOCKS.add(Blocks.field_150423_aK);
        CARRIABLE_BLOCKS.add(Blocks.field_150440_ba);
        CARRIABLE_BLOCKS.add((Block)Blocks.field_150391_bh);
        CARRIABLE_BLOCKS.add(Blocks.field_150424_aL);
    }

    static class AITakeBlock
    extends EntityAIBase {
        private final EntityRiftedEnderman enderman;

        public AITakeBlock(EntityRiftedEnderman p_i45841_1_) {
            this.enderman = p_i45841_1_;
        }

        public boolean func_75250_a() {
            if (this.enderman.getHeldBlockState() != null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.enderman.field_70170_p, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.func_70681_au().nextInt(20) == 0;
        }

        public void func_75246_d() {
            boolean flag;
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.field_70165_t - 2.0 + random.nextDouble() * 4.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.field_70163_u + random.nextDouble() * 3.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.field_70161_v - 2.0 + random.nextDouble() * 4.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            RayTraceResult raytraceresult = world.func_147447_a(new Vec3d((double)((float)MathHelper.func_76128_c((double)this.enderman.field_70165_t) + 0.5f), (double)((float)j + 0.5f), (double)((float)MathHelper.func_76128_c((double)this.enderman.field_70161_v) + 0.5f)), new Vec3d((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f)), false, true, false);
            boolean bl = flag = raytraceresult != null && raytraceresult.func_178782_a().equals((Object)blockpos);
            if (CARRIABLE_BLOCKS.contains(block) && flag) {
                this.enderman.setHeldBlockState(iblockstate);
                world.func_175698_g(blockpos);
            }
        }
    }

    static class AIPlaceBlock
    extends EntityAIBase {
        private final EntityRiftedEnderman enderman;

        public AIPlaceBlock(EntityRiftedEnderman p_i45843_1_) {
            this.enderman = p_i45843_1_;
        }

        public boolean func_75250_a() {
            if (this.enderman.getHeldBlockState() == null) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.enderman.field_70170_p, (Entity)this.enderman)) {
                return false;
            }
            return this.enderman.func_70681_au().nextInt(2000) == 0;
        }

        public void func_75246_d() {
            Random random = this.enderman.func_70681_au();
            World world = this.enderman.field_70170_p;
            int i = MathHelper.func_76128_c((double)(this.enderman.field_70165_t - 1.0 + random.nextDouble() * 2.0));
            int j = MathHelper.func_76128_c((double)(this.enderman.field_70163_u + random.nextDouble() * 2.0));
            int k = MathHelper.func_76128_c((double)(this.enderman.field_70161_v - 1.0 + random.nextDouble() * 2.0));
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            IBlockState iblockstate1 = world.func_180495_p(blockpos.func_177977_b());
            IBlockState iblockstate2 = this.enderman.getHeldBlockState();
            if (iblockstate2 != null && this.canPlaceBlock(world, blockpos, iblockstate2.func_177230_c(), iblockstate, iblockstate1) && ForgeEventFactory.onBlockPlace((Entity)this.enderman, (BlockSnapshot)new BlockSnapshot(world, blockpos, iblockstate2), (EnumFacing)EnumFacing.UP).isCanceled()) {
                world.func_180501_a(blockpos, iblockstate2, 3);
                this.enderman.setHeldBlockState(null);
            }
        }

        private boolean canPlaceBlock(World p_188518_1_, BlockPos p_188518_2_, Block p_188518_3_, IBlockState p_188518_4_, IBlockState p_188518_5_) {
            if (!p_188518_3_.func_176196_c(p_188518_1_, p_188518_2_)) {
                return false;
            }
            if (p_188518_4_.func_185904_a() != Material.field_151579_a) {
                return false;
            }
            if (p_188518_5_.func_185904_a() == Material.field_151579_a) {
                return false;
            }
            return p_188518_5_.func_185917_h();
        }
    }

    static class AIFindPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        private final EntityRiftedEnderman enderman;
        private EntityPlayer player;
        private int aggroTime;
        private int teleportTime;

        public AIFindPlayer(EntityRiftedEnderman riftedEnderman) {
            super((EntityCreature)riftedEnderman, EntityPlayer.class, false);
            this.enderman = riftedEnderman;
        }

        public boolean func_75250_a() {
            double d0 = this.func_111175_f();
            this.player = this.enderman.field_70170_p.func_184150_a(this.enderman.field_70165_t, this.enderman.field_70163_u, this.enderman.field_70161_v, d0, d0, null, p_apply_1_ -> p_apply_1_ != null && this.enderman.shouldAttackPlayer(p_apply_1_));
            return this.player != null;
        }

        public void func_75249_e() {
            this.aggroTime = 5;
            this.teleportTime = 0;
        }

        public void func_75251_c() {
            this.player = null;
            super.func_75251_c();
        }

        public boolean func_75253_b() {
            if (this.player != null) {
                if (!this.enderman.shouldAttackPlayer(this.player)) {
                    return false;
                }
                this.enderman.func_70625_a((Entity)this.player, 10.0f, 10.0f);
                return true;
            }
            return this.field_75309_a != null && ((EntityPlayer)this.field_75309_a).func_70089_S() || super.func_75253_b();
        }

        public void func_75246_d() {
            if (this.player != null) {
                if (--this.aggroTime <= 0) {
                    this.field_75309_a = this.player;
                    this.player = null;
                    super.func_75249_e();
                }
            } else {
                if (this.field_75309_a != null) {
                    if (this.enderman.shouldAttackPlayer((EntityPlayer)this.field_75309_a)) {
                        if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.enderman) < 16.0 && this.enderman.func_70681_au().nextInt(5) == 0) {
                            this.enderman.teleportRandomly();
                        }
                        this.teleportTime = 0;
                    } else if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportToEntity((Entity)this.field_75309_a)) {
                        this.teleportTime = 0;
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

