/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.google.common.base.Predicate;
import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.entity.Entities.ai.AIMoveControl;
import com.unoriginal.ancientbeasts.entity.Entities.ai.AIMoveRandom;
import com.unoriginal.ancientbeasts.entity.Entities.magic.MagicType;
import com.unoriginal.ancientbeasts.entity.Entities.magic.UseMagic;
import com.unoriginal.ancientbeasts.init.ModPotions;
import com.unoriginal.ancientbeasts.init.ModSounds;
import com.unoriginal.ancientbeasts.util.IMagicUser;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGhost
extends EntityMob
implements IMagicUser {
    public static final ResourceLocation LOOT = new ResourceLocation("ancientbeasts", "entities/Ghost");
    private EntityLivingBase possessedEntity;
    private int followTicks;

    public EntityGhost(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.9f);
        this.field_70765_h = new AIMoveControl(this);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)this, worldIn);
        pathnavigateflying.func_192879_a(true);
        pathnavigateflying.func_192877_c(true);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIPossession(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 1.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityMob.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(100));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false).func_190882_b(100));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0 * AncientBeastsConfig.GlobalHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0 + AncientBeastsConfig.GlobalDamageMultiplier);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        if (this.field_70170_p.func_72935_r() && this.field_71093_bK == 0 && !this.field_70170_p.field_72995_K) {
            this.func_70606_j(0.0f);
        }
        if (this.getPossessedEntity() != null && !this.field_70170_p.field_72995_K) {
            EntityLivingBase base = this.getPossessedEntity();
            if (--this.followTicks > 0) {
                this.field_70765_h.func_75642_a(base.field_70165_t, base.field_70163_u + (double)base.field_70131_O, base.field_70161_v, 1.0);
            }
            if (this.func_110143_aJ() <= 0.0f) {
                if (base.func_70644_a((Potion)ModPotions.POSSESSED) && base instanceof EntityPlayer) {
                    EntityPlayer p = (EntityPlayer)base;
                    p.func_184596_c((Potion)ModPotions.POSSESSED);
                } else {
                    base.func_70674_bp();
                }
            }
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    private void setPossessedEntity(@Nullable EntityLivingBase possessedIn) {
        this.possessedEntity = possessedIn;
    }

    @Nullable
    private EntityLivingBase getPossessedEntity() {
        return this.possessedEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @Override
    public boolean isUsingMagic() {
        return false;
    }

    @Override
    public int getMagicUseTicks() {
        return 0;
    }

    @Override
    public void setMagicUseTicks(int magicUseTicks) {
    }

    @Override
    public MagicType getMagicType() {
        return null;
    }

    @Override
    public void setMagicType(MagicType spellTypeIn) {
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.GHOST_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.GHOST_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.GHOST_DEATH;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    class EntityAIPossession
    extends UseMagic<EntityGhost> {
        final Predicate<EntityLivingBase> selector;

        protected EntityAIPossession(EntityGhost magicUserMob) {
            super(magicUserMob);
            this.selector = livingBase -> !(livingBase instanceof EntityGhost) && !livingBase.func_70644_a((Potion)ModPotions.POSSESSED) && !(livingBase instanceof EntityAnimal) && !livingBase.func_70644_a((Potion)ModPotions.GHOSTLY);
        }

        @Override
        public boolean func_75250_a() {
            if (EntityGhost.this.func_70638_az() == null) {
                return false;
            }
            if (EntityGhost.this.field_70173_aa < this.magicCooldown) {
                return false;
            }
            if (EntityGhost.this.isUsingMagic()) {
                return false;
            }
            List list = EntityGhost.this.field_70170_p.func_175647_a(EntityLivingBase.class, EntityGhost.this.func_174813_aQ().func_186662_g(16.0), this.selector);
            if (list.isEmpty()) {
                return false;
            }
            EntityGhost.this.setPossessedEntity((EntityLivingBase)list.get(EntityGhost.this.field_70146_Z.nextInt(list.size())));
            return true;
        }

        @Override
        protected void useMagic() {
            EntityLivingBase livingBase = EntityGhost.this.getPossessedEntity();
            EntityGhost.this.followTicks = 200;
            if (livingBase != null && !EntityGhost.this.field_70170_p.field_72995_K && livingBase instanceof EntityLiving && !(livingBase instanceof EntityVillager)) {
                EntityLiving possessed = (EntityLiving)livingBase;
                possessed.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 400));
                possessed.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 400, 2));
                possessed.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 400, 2));
                possessed.func_70624_b(EntityGhost.this.func_70638_az());
            } else if (livingBase instanceof EntityPlayer && !((EntityPlayer)livingBase).field_71075_bZ.field_75098_d || livingBase instanceof EntityVillager && !EntityGhost.this.field_70170_p.field_72995_K) {
                livingBase.func_70690_d(new PotionEffect((Potion)ModPotions.POSSESSED, 400));
                livingBase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)EntityGhost.this), 4.0f * (float)AncientBeastsConfig.GlobalDamageMultiplier);
            }
        }

        @Override
        public boolean func_75253_b() {
            return EntityGhost.this.getPossessedEntity() != null && this.magicWarmup > 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        @Override
        protected int getMagicUseTime() {
            return 400;
        }

        @Override
        protected int getMagicUseInterval() {
            return 400;
        }

        @Override
        @Nullable
        protected SoundEvent getMagicPrepareSound() {
            return ModSounds.GHOST_POSSESS;
        }

        @Override
        protected MagicType getMagicType() {
            return null;
        }
    }
}

