/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.entity.Entities.EntityIceCrystal;
import com.unoriginal.ancientbeasts.entity.Entities.EntityNetherhound;
import com.unoriginal.ancientbeasts.entity.Entities.magic.CastingMagic;
import com.unoriginal.ancientbeasts.entity.Entities.magic.MagicType;
import com.unoriginal.ancientbeasts.entity.Entities.magic.UseMagic;
import com.unoriginal.ancientbeasts.init.ModItems;
import com.unoriginal.ancientbeasts.init.ModSounds;
import com.unoriginal.ancientbeasts.util.IMagicUser;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFrostWalker
extends EntityMob
implements IMagicUser {
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityFrostWalker.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MAGIC_CAST = EntityDataManager.func_187226_a(EntityFrostWalker.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityFrostWalker.class, (DataSerializer)DataSerializers.field_187192_b);
    private int magicUseTicks;

    public EntityFrostWalker(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 2.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIFrostWalkerFastMelee(this, 2.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIFrostWalkerSlowMelee(this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAICastIceMagic(this));
        this.field_70714_bg.func_75776_a(3, new CastingMagic<EntityFrostWalker>(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 8.0f, 1.0, 1.25));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityIronGolem.class, 8.0f, 1.0, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityNetherhound.class, 10.0f, 0.8, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityFrostWalker.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityNetherhound.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(32.0 * AncientBeastsConfig.GlobalHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0 * AncientBeastsConfig.GlobalDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0 + AncientBeastsConfig.GlobalArmor);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ARMS_RAISED, (Object)Boolean.FALSE);
        this.func_184212_Q().func_187214_a(MAGIC_CAST, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.magicUseTicks > 0) {
            --this.magicUseTicks;
        }
    }

    public void func_70636_d() {
        float f;
        if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
            BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            float f2 = Math.min(16, 4);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(0, 0, 0);
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos1 : BlockPos.func_177975_b((BlockPos)pos.func_177963_a((double)(-f2), -1.0, (double)(-f2)), (BlockPos)pos.func_177963_a((double)f2, -1.0, (double)f2))) {
                IBlockState iblockstate1;
                if (!(blockpos$mutableblockpos1.func_177957_d(this.field_70165_t, this.field_70163_u, this.field_70161_v) <= (double)(f2 * f2))) continue;
                blockpos$mutableblockpos.func_181079_c(blockpos$mutableblockpos1.func_177958_n(), blockpos$mutableblockpos1.func_177956_o() + 1, blockpos$mutableblockpos1.func_177952_p());
                IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos);
                if (iblockstate.func_185904_a() != Material.field_151579_a || (iblockstate1 = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos1)).func_185904_a() != Material.field_151586_h || iblockstate1.func_177230_c() != Blocks.field_150355_j && iblockstate1.func_177230_c() != Blocks.field_150358_i || (Integer)iblockstate1.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 || !this.field_70170_p.func_190527_a(Blocks.field_185778_de, (BlockPos)blockpos$mutableblockpos1, false, EnumFacing.DOWN, null)) continue;
                this.field_70170_p.func_175656_a((BlockPos)blockpos$mutableblockpos1, Blocks.field_185778_de.func_176223_P());
                this.field_70170_p.func_175684_a(blockpos$mutableblockpos1.func_185334_h(), Blocks.field_185778_de, MathHelper.func_76136_a((Random)this.func_70681_au(), (int)60, (int)120));
            }
        }
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && !this.func_70631_g_() && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            boolean flag = true;
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        this.func_70669_a(itemstack);
                        this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    public static int getRandVariant(Random rand) {
        int i = rand.nextInt(100);
        if (i < 15) {
            return 1;
        }
        return 0;
    }

    public int getVariant() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(VARIANT)), (int)0, (int)4);
    }

    public void setVariant(int variantIn) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variantIn);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void setArmsRaised(boolean armsRaised) {
        this.field_70180_af.func_187227_b(ARMS_RAISED, (Object)armsRaised);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isArmsRaised() {
        return (Boolean)this.field_70180_af.func_187225_a(ARMS_RAISED);
    }

    public void setMagicCast(boolean magicCast) {
        this.field_70180_af.func_187227_b(MAGIC_CAST, (Object)magicCast);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isCastingMagic() {
        return (Boolean)this.field_70180_af.func_187225_a(MAGIC_CAST);
    }

    @Override
    public boolean isUsingMagic() {
        return this.magicUseTicks > 0;
    }

    @Override
    public int getMagicUseTicks() {
        return this.magicUseTicks;
    }

    @Override
    public void setMagicUseTicks(int magicUseTicks) {
        this.magicUseTicks = magicUseTicks;
    }

    @Override
    public MagicType getMagicType() {
        return null;
    }

    @Override
    public void setMagicType(MagicType spellTypeIn) {
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag && this.func_184614_ca().func_190926_b() && entityIn instanceof EntityLivingBase) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
            if (!(entityIn instanceof EntityNetherhound)) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100 * (int)f, 4));
            }
            if (this.isRed()) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 80, 3));
            }
        }
        return flag;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("MagicUseTicks", this.magicUseTicks);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.magicUseTicks = compound.func_74762_e("MagicUseTicks");
        this.setVariant(compound.func_74762_e("Variant"));
    }

    public boolean isRed() {
        return this.getVariant() > 0;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setVariant(EntityFrostWalker.getRandVariant(this.field_70170_p.field_73012_v));
        return livingdata;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            if (cause.func_76346_g() instanceof EntityPlayer && this.field_70146_Z.nextInt(4) == 0) {
                if (this.isRed()) {
                    this.func_70099_a(new ItemStack(ModItems.ICE_WAND_RED, 1, 0), 0.0f);
                } else {
                    this.func_70099_a(new ItemStack(ModItems.ICE_WAND, 1, 0), 0.0f);
                }
            }
            if (this.isRed()) {
                this.func_70099_a(new ItemStack(ModItems.ICE_DART, this.field_70170_p.field_73012_v.nextInt(3), 1), 0.0f);
            } else {
                this.func_70099_a(new ItemStack(ModItems.ICE_DART, this.field_70170_p.field_73012_v.nextInt(3), 0), 0.0f);
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186383_ah;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.FROSTWALKER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.FROSTWALKER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.FROSTWALKER_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187939_hm;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.getStepSound(), 0.15f, 1.0f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76347_k()) {
            amount *= 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public double func_70033_W() {
        return -0.5;
    }

    static class AIFrostWalkerSlowMelee
    extends EntityAIAttackMelee {
        private int raiseArmTicks;
        private final EntityFrostWalker zombie;

        public AIFrostWalkerSlowMelee(EntityFrostWalker creature, double speedIn, boolean useLongMemory) {
            super((EntityCreature)creature, speedIn, useLongMemory);
            this.zombie = creature;
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.raiseArmTicks = 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.zombie.setArmsRaised(false);
        }

        public void func_75246_d() {
            super.func_75246_d();
            ++this.raiseArmTicks;
            this.zombie.setArmsRaised(this.raiseArmTicks >= 5 && this.field_75439_d < 10);
        }
    }

    static class AIFrostWalkerFastMelee
    extends AIFrostWalkerSlowMelee {
        public AIFrostWalkerFastMelee(EntityFrostWalker creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.field_75441_b.func_70638_az().func_70644_a(MobEffects.field_76421_d);
        }
    }

    class EntityAICastIceMagic
    extends UseMagic<EntityFrostWalker> {
        protected EntityAICastIceMagic(EntityFrostWalker magicUserMob) {
            super(magicUserMob);
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            if (this.magicWarmup < 8) {
                EntityFrostWalker.this.setMagicCast(this.magicWarmup > 0);
            }
        }

        @Override
        protected void useMagic() {
            EntityLivingBase entitylivingbase = EntityFrostWalker.this.func_70638_az();
            double d0 = Math.min(entitylivingbase.field_70163_u, EntityFrostWalker.this.field_70163_u);
            double d1 = Math.max(entitylivingbase.field_70163_u, EntityFrostWalker.this.field_70163_u) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - EntityFrostWalker.this.field_70161_v), (double)(entitylivingbase.field_70165_t - EntityFrostWalker.this.field_70165_t));
            for (int l = 0; l < 10; ++l) {
                double d2 = 1.5 * (double)(l + 1);
                this.spawnIce(EntityFrostWalker.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, EntityFrostWalker.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, l);
            }
        }

        private void spawnIce(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                IBlockState iblockstate;
                AxisAlignedBB axisalignedbb;
                if (EntityFrostWalker.this.field_70170_p.func_175677_d(blockpos, true) || !EntityFrostWalker.this.field_70170_p.func_175677_d(blockpos.func_177977_b(), true)) continue;
                if (!EntityFrostWalker.this.field_70170_p.func_175623_d(blockpos) && (axisalignedbb = (iblockstate = EntityFrostWalker.this.field_70170_p.func_180495_p(blockpos)).func_185890_d((IBlockAccess)EntityFrostWalker.this.field_70170_p, blockpos)) != null) {
                    d0 = axisalignedbb.field_72337_e;
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                EntityIceCrystal iceCrystal = new EntityIceCrystal(EntityFrostWalker.this.field_70170_p, p_190876_1_, (double)blockpos.func_177956_o() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (EntityLivingBase)EntityFrostWalker.this, EntityFrostWalker.this.isRed());
                EntityFrostWalker.this.field_70170_p.func_72838_d((Entity)iceCrystal);
            }
        }

        @Override
        protected int getMagicUseTime() {
            return 100;
        }

        @Override
        protected int getMagicUseInterval() {
            return 300;
        }

        @Override
        protected SoundEvent getMagicPrepareSound() {
            return ModSounds.FROSTWALKER_PAIN;
        }

        @Override
        protected MagicType getMagicType() {
            return MagicType.SUMMON;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityFrostWalker.this.setMagicCast(false);
        }
    }
}

