/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.util.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Color;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.BiomeDictionary;

public class RenderUtils {
    static Gui gui = new Gui();
    static Cache<Biome, Integer> biomeColorCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public static int getBiomeColor(IBlockAccess worldIn, final Biome biome, final BlockPos pos) {
        if (worldIn != null) {
            int i = 0;
            int j = 0;
            int k = 0;
            for (final BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, 0, 1))) {
                final Biome biomeA = worldIn.func_180494_b((BlockPos)blockpos$mutableblockpos);
                int l = Color.WHITE.getRGB();
                try {
                    l = (Integer)biomeColorCache.get((Object)biomeA, (Callable)new Callable<Integer>(){

                        @Override
                        public Integer call() throws Exception {
                            Set types = BiomeDictionary.getTypes((Biome)biomeA);
                            Color foliageColor = new Color(biomeA.func_180625_c((BlockPos)blockpos$mutableblockpos));
                            Color waterColorMultiplier = new Color(biomeA.getWaterColorMultiplier());
                            Color grassColor = new Color(biomeA.func_180627_b((BlockPos)blockpos$mutableblockpos));
                            Color colorResult = RenderUtils.blend(RenderUtils.blend(foliageColor, waterColorMultiplier, 0.5f), grassColor, 0.5f);
                            for (BiomeDictionary.Type t : types) {
                                switch (t.getName()) {
                                    case "BEACH": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.35f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.3f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.1f)));
                                        break;
                                    }
                                    case "COLD": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, colorResult.getGreen()), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                        break;
                                    }
                                    case "CONIFEROUS": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, colorResult.getBlue()));
                                        break;
                                    }
                                    case "DEAD": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                        break;
                                    }
                                    case "DENSE": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.0f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.5f)), Math.min(255, colorResult.getBlue()));
                                        break;
                                    }
                                    case "DRY": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                        break;
                                    }
                                    case "END": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.4f)));
                                        break;
                                    }
                                    case "FOREST": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.9f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                        break;
                                    }
                                    case "HILLS": {
                                        colorResult = new Color(Math.min(255, colorResult.getRed() + 40), Math.min(255, colorResult.getGreen() + 40), Math.min(255, colorResult.getBlue() + 40));
                                        break;
                                    }
                                    case "HOT": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.1f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.0f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                        break;
                                    }
                                    case "JUNGLE": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.1f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                        break;
                                    }
                                    case "LUSH": {
                                        colorResult = new Color(Math.min(255, colorResult.getRed()), Math.min(255, (int)((float)colorResult.getGreen() * 1.4f)), Math.min(255, colorResult.getBlue()));
                                        break;
                                    }
                                    case "MAGICAL": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.5f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.3f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.5f)));
                                        break;
                                    }
                                    case "MESA": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.9f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.5f)));
                                        break;
                                    }
                                    case "MOUNTAIN": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.2f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                        break;
                                    }
                                    case "MUSHROOM": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.3f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.3f)));
                                        break;
                                    }
                                    case "NETHER": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.3f)));
                                        break;
                                    }
                                    case "OCEAN": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.4f)), Math.min(255, colorResult.getBlue()));
                                        break;
                                    }
                                    case "PLAINS": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.9f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.9f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.9f)));
                                        break;
                                    }
                                    case "RIVER": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.6f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.6f)), Math.min(255, colorResult.getBlue()));
                                        break;
                                    }
                                    case "SANDY": {
                                        colorResult = new Color(Math.min(255, (int)((double)colorResult.getRed() * 0.8)), Math.min(255, (int)((double)colorResult.getGreen() * 0.8)), Math.min(255, (int)((float)colorResult.getBlue() * 0.7f)));
                                        break;
                                    }
                                    case "SAVANNA": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.9f)));
                                        break;
                                    }
                                    case "SNOWY": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.4f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.5f)));
                                        break;
                                    }
                                    case "SPARSE": {
                                        colorResult = new Color(Math.min(255, colorResult.getRed()), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, colorResult.getBlue()));
                                        break;
                                    }
                                    case "SPOOKY": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.7f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.7f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.7f)));
                                        break;
                                    }
                                    case "SWAMP": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.6f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.4f)));
                                        break;
                                    }
                                    case "WASTELAND": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.2f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                        break;
                                    }
                                    case "WATER": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.5f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, colorResult.getBlue()));
                                        break;
                                    }
                                    case "WET": {
                                        colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.6f)), Math.min(255, colorResult.getGreen()), Math.min(255, colorResult.getBlue()));
                                        break;
                                    }
                                }
                            }
                            return colorResult.getRGB();
                        }
                    });
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                i += (l & 0xFF0000) >> 16;
                j += (l & 0xFF00) >> 8;
                k += l & 0xFF;
            }
            return (i / 9 & 0xFF) << 16 | (j / 9 & 0xFF) << 8 | k / 9 & 0xFF;
        }
        try {
            return (Integer)biomeColorCache.get((Object)biome, (Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    Set types = BiomeDictionary.getTypes((Biome)biome);
                    Color foliageColor = new Color(biome.func_180625_c(pos));
                    Color waterColorMultiplier = new Color(biome.getWaterColorMultiplier());
                    Color grassColor = new Color(biome.func_180627_b(pos));
                    Color colorResult = RenderUtils.blend(RenderUtils.blend(foliageColor, waterColorMultiplier, 0.5f), grassColor, 0.5f);
                    for (BiomeDictionary.Type t : types) {
                        switch (t.getName()) {
                            case "BEACH": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.35f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.3f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.1f)));
                                break;
                            }
                            case "COLD": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, colorResult.getGreen()), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                break;
                            }
                            case "CONIFEROUS": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, colorResult.getBlue()));
                                break;
                            }
                            case "DEAD": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                break;
                            }
                            case "DENSE": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.0f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.5f)), Math.min(255, colorResult.getBlue()));
                                break;
                            }
                            case "DRY": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                break;
                            }
                            case "END": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.4f)));
                                break;
                            }
                            case "FOREST": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.9f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                break;
                            }
                            case "HILLS": {
                                colorResult = new Color(Math.min(255, colorResult.getRed() + 40), Math.min(255, colorResult.getGreen() + 40), Math.min(255, colorResult.getBlue() + 40));
                                break;
                            }
                            case "HOT": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.1f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.0f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.8f)));
                                break;
                            }
                            case "JUNGLE": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.1f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                break;
                            }
                            case "LUSH": {
                                colorResult = new Color(Math.min(255, colorResult.getRed()), Math.min(255, (int)((float)colorResult.getGreen() * 1.4f)), Math.min(255, colorResult.getBlue()));
                                break;
                            }
                            case "MAGICAL": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.5f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.3f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.5f)));
                                break;
                            }
                            case "MESA": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.9f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.5f)));
                                break;
                            }
                            case "MOUNTAIN": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.2f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                break;
                            }
                            case "MUSHROOM": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.3f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.3f)));
                                break;
                            }
                            case "NETHER": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.8f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.3f)));
                                break;
                            }
                            case "OCEAN": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.4f)), Math.min(255, colorResult.getBlue()));
                                break;
                            }
                            case "PLAINS": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.9f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.9f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.9f)));
                                break;
                            }
                            case "RIVER": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.6f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.6f)), Math.min(255, colorResult.getBlue()));
                                break;
                            }
                            case "SANDY": {
                                colorResult = new Color(Math.min(255, (int)((double)colorResult.getRed() * 0.8)), Math.min(255, (int)((double)colorResult.getGreen() * 0.8)), Math.min(255, (int)((float)colorResult.getBlue() * 0.7f)));
                                break;
                            }
                            case "SAVANNA": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.1f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.9f)));
                                break;
                            }
                            case "SNOWY": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.4f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.5f)));
                                break;
                            }
                            case "SPARSE": {
                                colorResult = new Color(Math.min(255, colorResult.getRed()), Math.min(255, (int)((float)colorResult.getGreen() * 0.8f)), Math.min(255, colorResult.getBlue()));
                                break;
                            }
                            case "SPOOKY": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.7f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.7f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.7f)));
                                break;
                            }
                            case "SWAMP": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.4f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.6f)), Math.min(255, (int)((float)colorResult.getBlue() * 0.4f)));
                                break;
                            }
                            case "WASTELAND": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 1.2f)), Math.min(255, (int)((float)colorResult.getGreen() * 1.2f)), Math.min(255, (int)((float)colorResult.getBlue() * 1.2f)));
                                break;
                            }
                            case "WATER": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.5f)), Math.min(255, (int)((float)colorResult.getGreen() * 0.5f)), Math.min(255, colorResult.getBlue()));
                                break;
                            }
                            case "WET": {
                                colorResult = new Color(Math.min(255, (int)((float)colorResult.getRed() * 0.6f)), Math.min(255, colorResult.getGreen()), Math.min(255, colorResult.getBlue()));
                                break;
                            }
                        }
                    }
                    return colorResult.getRGB();
                }
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return Color.WHITE.getRGB();
        }
    }

    public static Color blend(Color c1, Color c2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int i1 = c1.getRGB();
        int i2 = c2.getRGB();
        int a1 = i1 >> 24 & 0xFF;
        int r1 = (i1 & 0xFF0000) >> 16;
        int g1 = (i1 & 0xFF00) >> 8;
        int b1 = i1 & 0xFF;
        int a2 = i2 >> 24 & 0xFF;
        int r2 = (i2 & 0xFF0000) >> 16;
        int g2 = (i2 & 0xFF00) >> 8;
        int b2 = i2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return new Color(a << 24 | r << 16 | g << 8 | b);
    }

    public static void drawCube(float posX, float posY, float posZ, float width, float length, float height, int red, int green, int blue, int alpha) {
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder wr = t.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)posZ);
        wr.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        wr.func_181662_b(0.0, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, 0.0, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b(0.0, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, (double)length).func_181669_b(red, green, blue, alpha).func_181675_d();
        wr.func_181662_b((double)width, (double)height, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179109_b((float)(-posX), (float)(-posY), (float)(-posZ));
        GlStateManager.func_179098_w();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    public static void renderModelCustomSides(IBlockAccess worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, BufferBuilder buffer, Map<EnumFacing, Boolean> faceMap, long rand) {
        boolean flag = Minecraft.func_71379_u() && stateIn.getLightValue(worldIn, posIn) == 0 && modelIn.func_177555_b();
        BlockModelRenderer bmr = Minecraft.func_71410_x().func_175602_ab().func_175019_b();
        if (bmr != null && stateIn != null && modelIn != null) {
            try {
                if (flag) {
                    float[] afloat = new float[EnumFacing.values().length * 2];
                    BitSet bitset = new BitSet(3);
                    BlockModelRenderer.AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = new BlockModelRenderer.AmbientOcclusionFace(bmr);
                    for (EnumFacing enumfacing : EnumFacing.values()) {
                        List list = modelIn.func_188616_a(stateIn, enumfacing, rand);
                        if (list.isEmpty() || !faceMap.get(enumfacing).booleanValue()) continue;
                        RenderUtils.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, list, afloat, bitset, blockmodelrenderer$ambientocclusionface);
                    }
                    List list1 = modelIn.func_188616_a(stateIn, (EnumFacing)null, rand);
                    if (!list1.isEmpty()) {
                        RenderUtils.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, list1, afloat, bitset, blockmodelrenderer$ambientocclusionface);
                    }
                } else {
                    BitSet bitset = new BitSet(3);
                    for (EnumFacing enumfacing : EnumFacing.values()) {
                        List list = modelIn.func_188616_a(stateIn, enumfacing, rand);
                        if (list.isEmpty() || !faceMap.get(enumfacing).booleanValue()) continue;
                        int i = stateIn.func_185889_a(worldIn, posIn.func_177972_a(enumfacing));
                        RenderUtils.renderQuadsFlat(worldIn, stateIn, posIn, i, false, buffer, list, bitset);
                        flag = true;
                    }
                    List list1 = modelIn.func_188616_a(stateIn, (EnumFacing)null, rand);
                    if (!list1.isEmpty()) {
                        RenderUtils.renderQuadsFlat(worldIn, stateIn, posIn, -1, true, buffer, list1, bitset);
                    }
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block model");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block model being tesselated");
                CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)posIn, (IBlockState)stateIn);
                crashreportcategory.func_71507_a("Using AO", (Object)flag);
                throw new ReportedException(crashreport);
            }
        }
    }

    public static Map<EnumFacing, List<BakedQuad>> getQuadFaceMapFromState(IBlockState state) {
        HashMap<EnumFacing, List<BakedQuad>> map = new HashMap<EnumFacing, List<BakedQuad>>();
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174954_c().func_178125_b(state);
        Random rng = new Random();
        for (EnumFacing f : EnumFacing.values()) {
            map.put(f, model.func_188616_a(state, f, rng.nextLong()));
        }
        map.put(null, model.func_188616_a(state, null, rng.nextLong()));
        return map;
    }

    public static void drawCube(float posX, float posY, float posZ, float size, int red, int green, int blue, int alpha) {
        RenderUtils.drawCube(posX, posY, posZ, size, size, size, red, green, blue, alpha);
    }

    public static void enableDefaultBlending() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    private static void renderQuadsSmooth(IBlockAccess blockAccessIn, IBlockState stateIn, BlockPos posIn, BufferBuilder buffer, List<BakedQuad> list, float[] quadBounds, BitSet bitSet, BlockModelRenderer.AmbientOcclusionFace aoFace) {
        Vec3d vec3d = stateIn.func_191059_e(blockAccessIn, posIn);
        double d0 = (double)posIn.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)posIn.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)posIn.func_177952_p() + vec3d.field_72449_c;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = list.get(i);
            RenderUtils.fillQuadBounds(stateIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), quadBounds, bitSet);
            aoFace.func_187491_a(blockAccessIn, stateIn, posIn, bakedquad.func_178210_d(), quadBounds, bitSet);
            buffer.func_178981_a(bakedquad.func_178209_a());
            buffer.func_178962_a(aoFace.field_178207_c[0], aoFace.field_178207_c[1], aoFace.field_178207_c[2], aoFace.field_178207_c[3]);
            if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                aoFace.field_178206_b[0] = aoFace.field_178206_b[0] * diffuse;
                aoFace.field_178206_b[1] = aoFace.field_178206_b[1] * diffuse;
                aoFace.field_178206_b[2] = aoFace.field_178206_b[2] * diffuse;
                aoFace.field_178206_b[3] = aoFace.field_178206_b[3] * diffuse;
            }
            if (bakedquad.func_178212_b()) {
                int k = Minecraft.func_71410_x().func_184125_al().func_186724_a(stateIn, blockAccessIn, posIn, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                buffer.func_178978_a(aoFace.field_178206_b[0] * f, aoFace.field_178206_b[0] * f1, aoFace.field_178206_b[0] * f2, 4);
                buffer.func_178978_a(aoFace.field_178206_b[1] * f, aoFace.field_178206_b[1] * f1, aoFace.field_178206_b[1] * f2, 3);
                buffer.func_178978_a(aoFace.field_178206_b[2] * f, aoFace.field_178206_b[2] * f1, aoFace.field_178206_b[2] * f2, 2);
                buffer.func_178978_a(aoFace.field_178206_b[3] * f, aoFace.field_178206_b[3] * f1, aoFace.field_178206_b[3] * f2, 1);
            } else {
                buffer.func_178978_a(aoFace.field_178206_b[0], aoFace.field_178206_b[0], aoFace.field_178206_b[0], 4);
                buffer.func_178978_a(aoFace.field_178206_b[1], aoFace.field_178206_b[1], aoFace.field_178206_b[1], 3);
                buffer.func_178978_a(aoFace.field_178206_b[2], aoFace.field_178206_b[2], aoFace.field_178206_b[2], 2);
                buffer.func_178978_a(aoFace.field_178206_b[3], aoFace.field_178206_b[3], aoFace.field_178206_b[3], 1);
            }
            buffer.func_178987_a(d0, d1, d2);
        }
    }

    private static void fillQuadBounds(IBlockState stateIn, int[] vertexData, EnumFacing face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * 7]);
            float f7 = Float.intBitsToFloat(vertexData[i * 7 + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * 7 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[EnumFacing.WEST.func_176745_a()] = f;
            quadBounds[EnumFacing.EAST.func_176745_a()] = f3;
            quadBounds[EnumFacing.DOWN.func_176745_a()] = f1;
            quadBounds[EnumFacing.UP.func_176745_a()] = f4;
            quadBounds[EnumFacing.NORTH.func_176745_a()] = f2;
            quadBounds[EnumFacing.SOUTH.func_176745_a()] = f5;
            int j = EnumFacing.values().length;
            quadBounds[EnumFacing.WEST.func_176745_a() + j] = 1.0f - f;
            quadBounds[EnumFacing.EAST.func_176745_a() + j] = 1.0f - f3;
            quadBounds[EnumFacing.DOWN.func_176745_a() + j] = 1.0f - f1;
            quadBounds[EnumFacing.UP.func_176745_a() + j] = 1.0f - f4;
            quadBounds[EnumFacing.NORTH.func_176745_a() + j] = 1.0f - f2;
            quadBounds[EnumFacing.SOUTH.func_176745_a() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (face) {
            case DOWN: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f1 < 1.0E-4f || stateIn.func_185917_h()) && f1 == f4);
                break;
            }
            case UP: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f4 > 0.9999f || stateIn.func_185917_h()) && f1 == f4);
                break;
            }
            case NORTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f2 < 1.0E-4f || stateIn.func_185917_h()) && f2 == f5);
                break;
            }
            case SOUTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f5 > 0.9999f || stateIn.func_185917_h()) && f2 == f5);
                break;
            }
            case WEST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f < 1.0E-4f || stateIn.func_185917_h()) && f == f3);
                break;
            }
            case EAST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f3 > 0.9999f || stateIn.func_185917_h()) && f == f3);
            }
        }
    }

    private static void renderQuadsFlat(IBlockAccess blockAccessIn, IBlockState stateIn, BlockPos posIn, int brightnessIn, boolean ownBrightness, BufferBuilder buffer, List<BakedQuad> list, BitSet bitSet) {
        Vec3d vec3d = stateIn.func_191059_e(blockAccessIn, posIn);
        double d0 = (double)posIn.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)posIn.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)posIn.func_177952_p() + vec3d.field_72449_c;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = list.get(i);
            if (ownBrightness) {
                RenderUtils.fillQuadBounds(stateIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? posIn.func_177972_a(bakedquad.func_178210_d()) : posIn;
                brightnessIn = stateIn.func_185889_a(blockAccessIn, blockpos);
            }
            buffer.func_178981_a(bakedquad.func_178209_a());
            buffer.func_178962_a(brightnessIn, brightnessIn, brightnessIn, brightnessIn);
            if (bakedquad.func_178212_b()) {
                int k = Minecraft.func_71410_x().func_184125_al().func_186724_a(stateIn, blockAccessIn, posIn, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                if (bakedquad.shouldApplyDiffuseLighting()) {
                    float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                    f *= diffuse;
                    f1 *= diffuse;
                    f2 *= diffuse;
                }
                buffer.func_178978_a(f, f1, f2, 4);
                buffer.func_178978_a(f, f1, f2, 3);
                buffer.func_178978_a(f, f1, f2, 2);
                buffer.func_178978_a(f, f1, f2, 1);
            } else if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                buffer.func_178978_a(diffuse, diffuse, diffuse, 4);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 3);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 2);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 1);
            }
            buffer.func_178987_a(d0, d1, d2);
        }
    }
}

