/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.magicavoxel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import lumien.randomthings.RandomThings;
import lumien.randomthings.config.Numbers;
import lumien.randomthings.handler.magicavoxel.ServerModelRequest;
import lumien.randomthings.network.PacketHandler;
import lumien.randomthings.network.messages.magicavoxel.MessageModelData;
import lumien.randomthings.network.messages.magicavoxel.MessageModelRequestUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;

public class ServerModelLibrary {
    Map<String, LoadedModelFile> loadedModels = new HashMap<String, LoadedModelFile>();
    Map<NetHandlerPlayServer, ServerModelRequest> modelRequests = new WeakHashMap<NetHandlerPlayServer, ServerModelRequest>();
    static ServerModelLibrary INSTANCE;

    public static ServerModelLibrary getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ServerModelLibrary();
        }
        return INSTANCE;
    }

    public List<String> getModelList() {
        return new ArrayList<String>(this.loadedModels.keySet());
    }

    public void tick() {
        Iterator<ServerModelRequest> iterator = this.modelRequests.values().iterator();
        int bytesAllowed = Numbers.MODEL_TRANSFER_BANDWIDTH;
        if (!this.modelRequests.isEmpty()) {
            int bytesPerRequest = bytesAllowed / this.modelRequests.size();
            if (bytesPerRequest <= 0) {
                RandomThings.instance.logger.log(Level.ERROR, "I have 1000 model requests? Probably a bug so please report! :)");
            }
            while (iterator.hasNext()) {
                ServerModelRequest request = iterator.next();
                if (request.netHandler.func_147362_b().func_150724_d()) {
                    int progress = request.bytesSend;
                    LoadedModelFile modelFile = this.loadedModels.get(request.modelName);
                    if (modelFile == null) {
                        iterator.remove();
                        RandomThings.instance.logger.log(Level.ERROR, "Expected Model request for " + request.modelName + " to exist on the server");
                        continue;
                    }
                    byte[] toSend = null;
                    if (progress < modelFile.modelData.length) {
                        toSend = new byte[Math.min(bytesPerRequest, modelFile.modelData.length - progress)];
                        for (int i = 0; i < toSend.length; ++i) {
                            toSend[i] = modelFile.modelData[progress + i];
                        }
                        progress += toSend.length;
                    } else if (progress < modelFile.modelData.length + modelFile.paletteData.length) {
                        toSend = new byte[Math.min(bytesPerRequest, modelFile.paletteData.length - (progress - modelFile.modelData.length))];
                        for (int i = 0; i < toSend.length; ++i) {
                            toSend[i] = modelFile.paletteData[progress - modelFile.modelData.length + i];
                        }
                        progress += toSend.length;
                    } else {
                        iterator.remove();
                    }
                    request.bytesSend = progress;
                    if (toSend == null) continue;
                    MessageModelData message = new MessageModelData(request.modelName, toSend.length, toSend);
                    request.netHandler.func_147359_a(PacketHandler.INSTANCE.getPacketFrom(message));
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public void load() {
        File modelFolder = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n(), "voxmodels");
        if (modelFolder.isDirectory()) {
            File[] modelFiles;
            for (File modelFile : modelFiles = modelFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".vox");
                }
            })) {
                try {
                    String modelName = modelFile.getName().substring(0, modelFile.getName().length() - 4);
                    File paletteFile = new File(modelFolder, modelName + ".act");
                    if (!(modelFile.length() > 2000000L || paletteFile.isFile() && paletteFile.length() > 2000000L)) {
                        InputStream paletteInputStream;
                        FileInputStream modelInputStream = new FileInputStream(modelFile);
                        if (paletteFile.isFile()) {
                            paletteInputStream = new FileInputStream(paletteFile);
                        } else {
                            paletteInputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("randomthings:voxmodels/default_palette.act")).func_110527_b();
                            FileOutputStream paletteOutput = new FileOutputStream(paletteFile);
                            int currentByte = -1;
                            while ((currentByte = paletteInputStream.read()) != -1) {
                                paletteOutput.write(currentByte);
                            }
                            paletteOutput.close();
                        }
                        LoadedModelFile loadedFile = new LoadedModelFile(IOUtils.toByteArray((InputStream)modelInputStream), IOUtils.toByteArray((InputStream)paletteInputStream));
                        this.loadedModels.put(modelName, loadedFile);
                        continue;
                    }
                    RandomThings.instance.logger.log(Level.ERROR, "Model file too large (Has to be smaller than 2mb) " + modelFile.getName());
                }
                catch (Exception e) {
                    RandomThings.instance.logger.log(Level.ERROR, "Error loading magica voxel model " + modelFile.getName());
                    e.printStackTrace();
                }
            }
        }
    }

    public void refresh() {
        this.loadedModels = new HashMap<String, LoadedModelFile>();
        this.modelRequests = new WeakHashMap<NetHandlerPlayServer, ServerModelRequest>();
        this.load();
    }

    public void requestModel(NetHandlerPlayServer serverHandler, String modelName) {
        MessageModelRequestUpdate updateMessage = new MessageModelRequestUpdate();
        if (this.loadedModels.containsKey(modelName)) {
            LoadedModelFile modelFile = this.loadedModels.get(modelName);
            updateMessage.setData(modelName, modelFile.modelData.length, modelFile.paletteData.length);
            ServerModelRequest request = new ServerModelRequest(modelName, serverHandler);
            this.modelRequests.put(serverHandler, request);
        } else {
            updateMessage.setData(modelName, -1, -1);
        }
        serverHandler.func_147359_a(PacketHandler.INSTANCE.getPacketFrom(updateMessage));
    }

    public class LoadedModelFile {
        Byte[] modelData;
        Byte[] paletteData;

        public LoadedModelFile(byte[] modelData, byte[] paletteData) {
            this.modelData = ArrayUtils.toObject((byte[])modelData);
            this.paletteData = ArrayUtils.toObject((byte[])paletteData);
        }

        public Byte[] getModelData() {
            return this.modelData;
        }

        public Byte[] getPaletteData() {
            return this.paletteData;
        }
    }
}

