/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import lumien.randomthings.item.ModItems;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EscapeRopeHandler {
    static EscapeRopeHandler INSTANCE;
    List<Task> runningTasks = new ArrayList<Task>();

    public void addTask(EntityPlayerMP player) {
        Task t = new Task();
        t.player = new WeakReference<EntityPlayerMP>(player);
        t.toCheck.add(player.func_180425_c());
        this.runningTasks.add(t);
    }

    public void tick() {
        Iterator<Task> iterator = this.runningTasks.iterator();
        block0: while (iterator.hasNext()) {
            Task t = iterator.next();
            EntityPlayerMP actualPlayer = (EntityPlayerMP)t.player.get();
            if (actualPlayer == null || actualPlayer.field_70170_p == null) continue;
            ItemStack holding = actualPlayer.func_184607_cu();
            if (!holding.func_190926_b() && holding.func_77973_b() == ModItems.escapeRope) {
                ArrayList<BlockPos> toCheck = t.toCheck;
                HashSet<BlockPos> alreadyChecked = t.alreadyChecked;
                World world = actualPlayer.field_70170_p;
                for (int runs = 0; runs < 4; ++runs) {
                    boolean finished = false;
                    if (toCheck.isEmpty() || alreadyChecked.size() > 10000) {
                        finished = true;
                        actualPlayer.func_71019_a(holding, false);
                        actualPlayer.func_184611_a(actualPlayer.func_184600_cs(), ItemStack.field_190927_a);
                    } else {
                        BlockPos nextPos = toCheck.remove(toCheck.size() - 1);
                        while (alreadyChecked.contains(nextPos) && toCheck.size() > 0) {
                            nextPos = toCheck.remove(toCheck.size() - 1);
                        }
                        if (!alreadyChecked.contains(nextPos)) {
                            if (world.func_190526_b(nextPos.func_177958_n() >> 4, nextPos.func_177952_p() >> 4) && world.func_175623_d(nextPos) || world.func_180495_p(nextPos).func_185890_d((IBlockAccess)world, nextPos) == null) {
                                if (world.func_175710_j(nextPos)) {
                                    world.func_184133_a((EntityPlayer)actualPlayer, actualPlayer.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 0.5f, 1.0f);
                                    boolean foundSolid = false;
                                    for (int y = nextPos.func_177956_o(); y >= 0; --y) {
                                        BlockPos target = new BlockPos(nextPos.func_177958_n(), y, nextPos.func_177952_p());
                                        if (!world.isSideSolid(target, EnumFacing.UP) && !world.func_180495_p(target).func_185913_b()) continue;
                                        actualPlayer.field_71135_a.func_147364_a((double)target.func_177958_n() + 0.5, (double)(target.func_177956_o() + 1), (double)target.func_177952_p() + 0.5, actualPlayer.field_70177_z, actualPlayer.field_70125_A);
                                        foundSolid = true;
                                        break;
                                    }
                                    if (!foundSolid) {
                                        actualPlayer.field_71135_a.func_147364_a((double)nextPos.func_177958_n() + 0.5, (double)(nextPos.func_177956_o() + 1), (double)nextPos.func_177952_p() + 0.5, actualPlayer.field_70177_z, actualPlayer.field_70125_A);
                                    }
                                    actualPlayer.func_184602_cy();
                                    world.func_184133_a(null, actualPlayer.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 0.5f, 1.0f);
                                    holding.func_77972_a(1, (EntityLivingBase)actualPlayer);
                                    finished = true;
                                } else {
                                    alreadyChecked.add(nextPos);
                                    if (!alreadyChecked.contains(nextPos.func_177972_a(EnumFacing.DOWN))) {
                                        toCheck.add(nextPos.func_177972_a(EnumFacing.DOWN));
                                    }
                                    for (EnumFacing facing : EnumFacing.field_176754_o) {
                                        BlockPos addPos = new BlockPos((Vec3i)nextPos.func_177972_a(facing));
                                        if (alreadyChecked.contains(addPos)) continue;
                                        toCheck.add(addPos);
                                    }
                                    if (!alreadyChecked.contains(nextPos.func_177972_a(EnumFacing.UP))) {
                                        toCheck.add(nextPos.func_177972_a(EnumFacing.UP));
                                    }
                                }
                            }
                        } else {
                            finished = true;
                        }
                    }
                    if (!finished) continue;
                    iterator.remove();
                    continue block0;
                }
                continue;
            }
            iterator.remove();
        }
    }

    public static EscapeRopeHandler getInstance() {
        return INSTANCE != null ? INSTANCE : (INSTANCE = new EscapeRopeHandler());
    }

    class Task {
        WeakReference<EntityPlayerMP> player;
        ArrayList<BlockPos> toCheck = new ArrayList();
        HashSet<BlockPos> alreadyChecked = new HashSet();

        Task() {
        }
    }
}

