/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.entitys;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEnchantmentTable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityArtificialEndPortal
extends Entity
implements IEntityAdditionalSpawnData {
    public int actionTimer;

    public EntityArtificialEndPortal(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 1.0f);
    }

    public EntityArtificialEndPortal(World worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.actionTimer < 200) {
            ++this.actionTimer;
            if (this.field_70170_p.field_72995_K && this.actionTimer > 40) {
                this.spawnParticles();
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82737_E() % 40L == 0L && !EntityArtificialEndPortal.isValidPosition(this.field_70170_p, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), false)) {
                this.func_70106_y();
            }
        } else if (this.actionTimer == 85) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187812_eh, SoundCategory.BLOCKS, 0.2f, 1.0f, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        for (int i = 0; i < 5; ++i) {
            ParticleEnchantmentTable.EnchantmentTable builder = new ParticleEnchantmentTable.EnchantmentTable();
            double modX = Math.random() * (double)0.05f - (double)0.025f;
            double modZ = Math.random() * (double)0.05f - (double)0.025f;
            Particle particle = builder.func_178902_a(0, this.field_70170_p, this.field_70165_t + modX, this.field_70163_u + 2.0, this.field_70161_v + modZ, modX * 2.0, 1.0, modZ * 2.0, new int[0]);
            particle.func_70538_b(0.2f + (float)Math.random() * 0.1f, 0.0f, 0.3f + (float)Math.random() * 0.1f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        super.func_70100_b_(entityIn);
        if (!this.field_70170_p.field_72995_K && this.actionTimer >= 200 && entityIn.func_174813_aQ().func_72326_a(this.func_174813_aQ()) && !entityIn.func_184218_aH() && !entityIn.func_184207_aI()) {
            entityIn.func_184204_a(1);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.actionTimer = compound.func_74762_e("actionTimer");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("actionTimer", this.actionTimer);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.actionTimer);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.actionTimer = additionalData.readInt();
    }

    public static boolean isValidPosition(World world, BlockPos center, boolean checkForOtherPortals) {
        List portalList;
        int modZ;
        int modX;
        for (modX = -1; modX < 2; ++modX) {
            for (modZ = -1; modZ < 2; ++modZ) {
                if (world.func_175623_d(center.func_177982_a(modX, 0, modZ))) continue;
                return false;
            }
        }
        for (int modY = 1; modY < 3; ++modY) {
            if (world.func_175623_d(center.func_177982_a(0, modY, 0))) continue;
            return false;
        }
        if (world.func_180495_p(center.func_177982_a(0, 3, 0)).func_177230_c() != Blocks.field_185764_cQ || world.func_180495_p(center.func_177982_a(0, 4, 0)).func_177230_c() != Blocks.field_150377_bs) {
            return false;
        }
        for (modX = -1; modX < 2; ++modX) {
            for (modZ = -1; modZ < 2; ++modZ) {
                if (world.func_180495_p(center.func_177982_a(modX, -1, modZ)).func_177230_c() == Blocks.field_150377_bs) continue;
                return false;
            }
        }
        for (modX = -2; modX < 3; ++modX) {
            for (modZ = -2; modZ < 3; ++modZ) {
                if (modX != -2 && modZ != -2 && modX != 2 && modZ != 2 || world.func_180495_p(center.func_177982_a(modX, 0, modZ)).func_177230_c() == Blocks.field_150343_Z) continue;
                return false;
            }
        }
        return !checkForOtherPortals || (portalList = world.func_72872_a(EntityArtificialEndPortal.class, new AxisAlignedBB(center, center.func_177982_a(1, 2, 1)))).isEmpty();
    }
}

