/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.config;

import java.lang.reflect.Field;
import java.util.Set;
import lumien.randomthings.RandomThings;
import lumien.randomthings.config.Features;
import lumien.randomthings.config.Worldgen;
import lumien.randomthings.lib.ConfigOption;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class ModConfiguration {
    Configuration configuration;

    public void preInit(FMLPreInitializationEvent event) {
        this.configuration = new Configuration(event.getSuggestedConfigurationFile());
        this.configuration.load();
        Features.removeAirBubble = this.configuration.getBoolean("RemoveUnderwaterTexture", "Features", false, "TRIES to remove the weird water texture showing around ALL non full blocks. This might look weird when you, for example, are on a ladder underwater.");
        this.configuration.getCategory("worldgen").setComment("Set to false to disable the generation of the respective objects");
        Worldgen.beans = this.configuration.get("worldgen", "Beans", true).getBoolean();
        Worldgen.natureCore = this.configuration.get("worldgen", "Nature-Core", true).getBoolean();
        Worldgen.pitcherPlants = this.configuration.get("worldgen", "PitcherPlants", true).getBoolean();
        Worldgen.sakanade = this.configuration.get("worldgen", "Sakanade", true).getBoolean();
        this.doAnnoations(this.configuration);
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    private void doAnnoations(Configuration configuration) {
        ASMDataTable asmData = RandomThings.instance.getASMData();
        Set atlasSet = asmData.getAll(ConfigOption.class.getName());
        for (ASMDataTable.ASMData data : atlasSet) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                Field f = clazz.getDeclaredField(data.getObjectName());
                f.setAccessible(true);
                String name = (String)data.getAnnotationInfo().get("name");
                String category = (String)data.getAnnotationInfo().get("category");
                String comment = (String)data.getAnnotationInfo().get("comment");
                Comparable<Boolean> result = null;
                if (f.getType() == Boolean.TYPE) {
                    result = configuration.get(category, name, f.getBoolean(null), comment).getBoolean();
                } else if (f.getType() == Double.TYPE) {
                    result = configuration.get(category, name, f.getDouble(null), comment).getDouble();
                } else if (f.getType() == Integer.TYPE) {
                    result = configuration.get(category, name, f.getInt(null), comment).getInt();
                }
                if (result != null) {
                    f.set(null, result);
                    continue;
                }
                throw new RuntimeException("Invalid Data Type for Config annotation: " + f.getType());
            }
            catch (Exception e) {
                RandomThings.instance.logger.log(Level.ERROR, "Error stitching extra textures");
                e.printStackTrace();
            }
        }
    }
}

