/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.client.render;

import java.util.ArrayList;
import java.util.List;
import lumien.randomthings.handler.RTEventHandler;
import lumien.randomthings.tileentity.TileEntityAncientFurnace;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.tuple.Pair;

public class RenderAncientFurnace
extends TileEntitySpecialRenderer<TileEntityAncientFurnace> {
    static final Pair<Integer, Integer>[] offsets = new Pair[]{Pair.of((Object)-1, (Object)0), Pair.of((Object)-1, (Object)-1), Pair.of((Object)0, (Object)-1), Pair.of((Object)1, (Object)-1), Pair.of((Object)1, (Object)0), Pair.of((Object)1, (Object)1), Pair.of((Object)0, (Object)1), Pair.of((Object)-1, (Object)1)};
    static final ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("randomthings:textures/blocks/ancientbrick_o0.png"), new ResourceLocation("randomthings:textures/blocks/ancientbrick_o1.png"), new ResourceLocation("randomthings:textures/blocks/ancientbrick_o2.png"), new ResourceLocation("randomthings:textures/blocks/ancientbrick_o3.png")};
    static final int[][] textureIndices = new int[][]{{2, 3, 0, 1}, {1, 2, 3, 0}, {0, 1, 2, 3}, {3, 0, 1, 2}};
    static final List<Overlay> toDraw = new ArrayList<Overlay>();

    public void render(TileEntityAncientFurnace te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        TileEntityAncientFurnace.STATE state = te.getState();
        int counter = te.getStartingCounter();
        float transparency = 0.0f;
        if (state == TileEntityAncientFurnace.STATE.RUNNING) {
            transparency = 1.0f;
        } else if (state == TileEntityAncientFurnace.STATE.STARTING && counter > 100) {
            transparency = Math.min(1.0f, -1.0f * (float)Math.cos((double)((float)counter + partialTicks - 100.0f) / 300.0 * 1.5707963267948966) + 1.0f);
        }
        if (state == TileEntityAncientFurnace.STATE.RUNNING || state == TileEntityAncientFurnace.STATE.STARTING && counter > 100) {
            GlStateManager.func_179092_a((int)519, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_190053_a(true);
            GlStateManager.func_179140_f();
            float yellow = ((float)Math.sin(((float)RTEventHandler.clientAnimationCounter + partialTicks) / 25.0f) + 1.0f) / 5.0f + 0.1f;
            GlStateManager.func_179131_c((float)1.0f, (float)yellow, (float)0.0f, (float)transparency);
            for (Overlay o : toDraw) {
                Pair<Integer, Integer> offset = o.offset;
                long rdm = MathHelper.func_180186_a((Vec3i)new Vec3i(te.func_174877_v().func_177958_n() + (Integer)offset.getLeft(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p() + (Integer)offset.getRight()));
                int model = RenderAncientFurnace.getRandomInteger(4, Math.abs((int)rdm >> 16) % 4);
                for (EnumFacing f : o.facings) {
                    ResourceLocation texture = textures[textureIndices[model][f.func_176736_b()]];
                    this.func_147499_a(texture);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder renderer = tessellator.func_178180_c();
                    renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    double iX = x + (double)((Integer)offset.getLeft()).intValue();
                    double iZ = z + (double)((Integer)offset.getRight()).intValue();
                    switch (f) {
                        case NORTH: {
                            renderer.func_181662_b(iX, y, iZ - 0.001).func_187315_a(1.0, 1.0).func_181675_d();
                            renderer.func_181662_b(iX, y + 1.0, iZ - 0.001).func_187315_a(1.0, 0.0).func_181675_d();
                            renderer.func_181662_b(iX + 1.0, y + 1.0, iZ - 0.001).func_187315_a(0.0, 0.0).func_181675_d();
                            renderer.func_181662_b(iX + 1.0, y, iZ - 0.001).func_187315_a(0.0, 1.0).func_181675_d();
                            break;
                        }
                        case SOUTH: {
                            renderer.func_181662_b(iX, y, iZ + 1.001).func_187315_a(0.0, 1.0).func_181675_d();
                            renderer.func_181662_b(iX + 1.0, y, iZ + 1.001).func_187315_a(1.0, 1.0).func_181675_d();
                            renderer.func_181662_b(iX + 1.0, y + 1.0, iZ + 1.001).func_187315_a(1.0, 0.0).func_181675_d();
                            renderer.func_181662_b(iX, y + 1.0, iZ + 1.001).func_187315_a(0.0, 0.0).func_181675_d();
                            break;
                        }
                        case WEST: {
                            renderer.func_181662_b(iX - 0.001, y, iZ).func_187315_a(0.0, 1.0).func_181675_d();
                            renderer.func_181662_b(iX - 0.001, y, iZ + 1.0).func_187315_a(1.0, 1.0).func_181675_d();
                            renderer.func_181662_b(iX - 0.001, y + 1.0, iZ + 1.0).func_187315_a(1.0, 0.0).func_181675_d();
                            renderer.func_181662_b(iX - 0.001, y + 1.0, iZ).func_187315_a(0.0, 0.0).func_181675_d();
                            break;
                        }
                        case EAST: {
                            renderer.func_181662_b(iX + 1.001, y, iZ).func_187315_a(1.0, 1.0).func_181675_d();
                            renderer.func_181662_b(iX + 1.001, y + 1.0, iZ).func_187315_a(1.0, 0.0).func_181675_d();
                            renderer.func_181662_b(iX + 1.001, y + 1.0, iZ + 1.0).func_187315_a(0.0, 0.0).func_181675_d();
                            renderer.func_181662_b(iX + 1.001, y, iZ + 1.0).func_187315_a(0.0, 1.0).func_181675_d();
                            break;
                        }
                    }
                    tessellator.func_78381_a();
                }
            }
            this.func_190053_a(false);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
    }

    public static int getRandomInteger(int count, int weight) {
        int j = count;
        for (int i = 0; i < j; ++i) {
            if (--weight >= 0) continue;
            return i;
        }
        return 0;
    }

    static {
        toDraw.add(new Overlay((Pair<Integer, Integer>)Pair.of((Object)0, (Object)-1), new EnumFacing[]{EnumFacing.NORTH}));
        toDraw.add(new Overlay((Pair<Integer, Integer>)Pair.of((Object)0, (Object)1), new EnumFacing[]{EnumFacing.SOUTH}));
        toDraw.add(new Overlay((Pair<Integer, Integer>)Pair.of((Object)1, (Object)0), new EnumFacing[]{EnumFacing.EAST}));
        toDraw.add(new Overlay((Pair<Integer, Integer>)Pair.of((Object)-1, (Object)0), new EnumFacing[]{EnumFacing.WEST}));
        toDraw.add(new Overlay((Pair<Integer, Integer>)Pair.of((Object)1, (Object)-1), new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST}));
        toDraw.add(new Overlay((Pair<Integer, Integer>)Pair.of((Object)1, (Object)1), new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.EAST}));
        toDraw.add(new Overlay((Pair<Integer, Integer>)Pair.of((Object)-1, (Object)1), new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST}));
        toDraw.add(new Overlay((Pair<Integer, Integer>)Pair.of((Object)-1, (Object)-1), new EnumFacing[]{EnumFacing.NORTH, EnumFacing.WEST}));
    }

    static class Overlay {
        Pair<Integer, Integer> offset;
        EnumFacing[] facings;

        public Overlay(Pair<Integer, Integer> offset, EnumFacing[] facings) {
            this.offset = offset;
            this.facings = facings;
        }
    }
}

