/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block.plates;

import com.google.common.base.Predicate;
import lumien.randomthings.RandomThings;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.tileentity.TileEntityExtractionPlate;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockExtractionPlate
extends BlockContainerBase {
    protected static final AxisAlignedBB AABB = null;
    protected static final AxisAlignedBB VISUAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.03125, 1.0);
    public static final PropertyDirection OUTPUT_FACING = PropertyDirection.func_177712_a((String)"outputfacing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockExtractionPlate() {
        super("plate_extraction", Material.field_151578_c);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canPlaceOn(worldIn, pos.func_177977_b());
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        return worldIn.isSideSolid(pos, EnumFacing.UP);
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceOn(worldIn, pos.func_177977_b())) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return VISUAL_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing currentOutput = (EnumFacing)state.func_177229_b((IProperty)OUTPUT_FACING);
        return currentOutput.ordinal() - 2;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > 3) {
            meta = 0;
        }
        EnumFacing output = EnumFacing.values()[meta + 2];
        return this.func_176223_P().func_177226_a((IProperty)OUTPUT_FACING, (Comparable)output);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{OUTPUT_FACING});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side == EnumFacing.UP && playerIn.func_70093_af()) {
            EnumFacing newOutput;
            EnumFacing currentOutput = (EnumFacing)state.func_177229_b((IProperty)OUTPUT_FACING);
            if (currentOutput != (newOutput = EnumFacing.func_176737_a((float)(hitX - 0.5f), (float)0.0f, (float)(hitZ - 0.5f)))) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)OUTPUT_FACING, (Comparable)newOutput));
                }
                return true;
            }
        } else {
            if (!worldIn.field_72995_K) {
                playerIn.openGui((Object)RandomThings.instance, 33, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
        this.checkForDrop(worldIn, pos, state);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)OUTPUT_FACING, (Comparable)placer.func_174811_aO());
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            // empty if block
        }
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityExtractionPlate();
    }
}

