/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import java.util.Random;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.handler.runes.EnumRuneDust;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.lib.ILuminousBlock;
import lumien.randomthings.lib.INoItem;
import lumien.randomthings.lib.IRTBlockColor;
import lumien.randomthings.tileentity.TileEntityRuneBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRuneBase
extends BlockContainerBase
implements IRTBlockColor,
ILuminousBlock,
INoItem {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.005, 1.0);
    public static final RuneDataProperty RUNE_DATA = new RuneDataProperty();
    public static final ConnectionDataProperty CONNECTION_DATA = new ConnectionDataProperty();

    protected BlockRuneBase() {
        super("runeBase", Material.field_151595_p);
        this.func_149711_c(0.2f);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        if (!downState.isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
            worldIn.func_175698_g(pos);
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityRuneBase) {
            TileEntityRuneBase runeTE = (TileEntityRuneBase)te;
            int[][] runeData = runeTE.getRuneData();
            for (int x = 0; x < runeData.length; ++x) {
                for (int y = 0; y < runeData[0].length; ++y) {
                    int rune = runeData[x][y];
                    if (rune == -1) continue;
                    ItemStack dustStack = new ItemStack((Item)ModItems.runeDust, 1, rune);
                    EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + (double)((float)x / 4.0f), (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + (double)((float)y / 4.0f), dustStack);
                    entityitem.func_174868_q();
                    worldIn.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 0;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        BlockPos hitPos;
        Vec3d start;
        RayTraceResult result;
        if (!worldIn.field_72995_K && (result = worldIn.func_147447_a(start = playerIn.func_174824_e(0.0f), start.func_178787_e(playerIn.func_70040_Z().func_186678_a(6.0)), false, true, false)) != null && result.field_72313_a == RayTraceResult.Type.BLOCK && (hitPos = result.func_178782_a()).equals((Object)pos)) {
            int y;
            int x;
            Vec3d hitVec = result.field_72307_f.func_178788_d(new Vec3d((Vec3i)pos));
            TileEntityRuneBase te = (TileEntityRuneBase)worldIn.func_175625_s(pos);
            int[][] runeData = te.getRuneData();
            if (runeData[x = (int)Math.floor(hitVec.field_72450_a * 4.0)][y = (int)Math.floor(hitVec.field_72449_c * 4.0)] != -1) {
                EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + hitVec.field_72450_a, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + hitVec.field_72449_c, new ItemStack((Item)ModItems.runeDust, 1, runeData[x][y]));
                entityitem.func_174868_q();
                worldIn.func_72838_d((Entity)entityitem);
                runeData[x][y] = -1;
                te.syncTE();
                worldIn.func_184133_a(null, pos, SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 1.0f, 0.8f);
                boolean empty = true;
                for (x = 0; x < runeData.length; ++x) {
                    for (y = 0; y < runeData[0].length; ++y) {
                        int rune = runeData[x][y];
                        if (rune == -1) continue;
                        empty = false;
                        break;
                    }
                    if (!empty) break;
                }
                if (empty) {
                    worldIn.func_175698_g(pos);
                }
            }
        }
        super.func_180649_a(worldIn, pos, playerIn);
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityRuneBase();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean shouldGlow(IBlockState state, int tintIndex) {
        return true;
    }

    @Override
    public int colorMultiplier(IBlockState state, IBlockAccess p_186720_2_, BlockPos pos, int tintIndex) {
        return EnumRuneDust.getColor(tintIndex);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return AABB.func_186670_a(pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{RUNE_DATA, CONNECTION_DATA});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityRuneBase te = (TileEntityRuneBase)worldIn.func_175625_s(pos);
        IExtendedBlockState actualState = (IExtendedBlockState)state;
        if (te != null) {
            boolean[] connectionData = new boolean[16];
            int[][] runeData = te.getRuneData();
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos mod = pos.func_177972_a(facing);
                TileEntity otherTE = worldIn.func_175625_s(mod);
                if (!(otherTE instanceof TileEntityRuneBase)) continue;
                TileEntityRuneBase otherRune = (TileEntityRuneBase)otherTE;
                int[][] otherRuneData = otherRune.getRuneData();
                for (int i = 0; i < 4; ++i) {
                    if (facing == EnumFacing.NORTH) {
                        connectionData[i] = runeData[i][0] == otherRuneData[i][3];
                        continue;
                    }
                    if (facing == EnumFacing.EAST) {
                        connectionData[i + 4] = runeData[3][i] == otherRuneData[0][i];
                        continue;
                    }
                    if (facing == EnumFacing.SOUTH) {
                        connectionData[i + 8] = runeData[i][3] == otherRuneData[i][0];
                        continue;
                    }
                    if (facing != EnumFacing.WEST) continue;
                    connectionData[i + 12] = runeData[0][i] == otherRuneData[3][i];
                }
            }
            return actualState.withProperty((IUnlistedProperty)RUNE_DATA, (Object)runeData).withProperty((IUnlistedProperty)CONNECTION_DATA, (Object)connectionData);
        }
        return actualState.withProperty((IUnlistedProperty)RUNE_DATA, (Object)new int[4][4]);
    }

    private static class ConnectionDataProperty
    implements IUnlistedProperty<boolean[]> {
        private ConnectionDataProperty() {
        }

        public String getName() {
            return "runedata";
        }

        public boolean isValid(boolean[] value) {
            return true;
        }

        public Class<boolean[]> getType() {
            return boolean[].class;
        }

        public String valueToString(boolean[] value) {
            return value.toString();
        }
    }

    private static class RuneDataProperty
    implements IUnlistedProperty<int[][]> {
        private RuneDataProperty() {
        }

        public String getName() {
            return "runedata";
        }

        public boolean isValid(int[][] value) {
            return true;
        }

        public Class<int[][]> getType() {
            return int[][].class;
        }

        public String valueToString(int[][] value) {
            return value.toString();
        }
    }
}

