/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import lumien.randomthings.RandomThings;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.tileentity.TileEntityInventoryTester;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockInventoryTester
extends BlockContainerBase {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.375, 0.375, 0.9375, 0.625, 0.625, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.0625);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.9375, 0.375, 0.375, 1.0, 0.625, 0.625);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 0.0625, 0.625, 0.625);
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.0625, 0.625);
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.375, 0.9375, 0.375, 0.625, 1.0, 0.625);

    protected BlockInventoryTester() {
        super("inventoryTester", Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.func_149711_c(0.3f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)RandomThings.instance, 25, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityInventoryTester te = (TileEntityInventoryTester)blockAccess.func_175625_s(pos);
        return te.isPowered() ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityInventoryTester();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return BlockInventoryTester.canPlaceAgainst(worldIn, pos, side.func_176734_d());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockInventoryTester.canPlaceAgainst(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceAgainst(World p_181088_0_, BlockPos p_181088_1_, EnumFacing p_181088_2_) {
        return p_181088_2_ == EnumFacing.DOWN && BlockInventoryTester.isBlockInventory(p_181088_0_, p_181088_1_.func_177977_b(), p_181088_2_) ? true : BlockInventoryTester.isBlockInventory(p_181088_0_, p_181088_1_.func_177972_a(p_181088_2_), p_181088_2_);
    }

    private static boolean isBlockInventory(World worldObj, BlockPos pos, EnumFacing facing) {
        TileEntity te = worldObj.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        return te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return BlockInventoryTester.canPlaceAgainst(worldIn, pos, facing.func_176734_d()) ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        if (this.checkForDrop(worldIn, pos, state) && !BlockInventoryTester.canPlaceAgainst(worldIn, pos, ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (enumfacing) {
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case UP: {
                return UP_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
        }
        return UP_AABB;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

