/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.worldgen;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import com.pam.harvestcraft.config.TreeGenerationConfiguration;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class FruitTreeWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!HarvestCraft.fruitTreeConfigManager.enableFruitTreeGeneration) {
            HarvestCraft.log.debug("disabled fruit tree generation");
            return;
        }
        int x = chunkX * 16 + 8 + random.nextInt(16);
        int z = chunkZ * 16 + 8 + random.nextInt(16);
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 64, z));
        int rarity = random.nextInt(100);
        List<TreeGenerationConfiguration> fruitTreesRarity = HarvestCraft.fruitTreeConfigManager.getFruitTreesInBiomeWithLowerRarity(rarity, biome);
        if (fruitTreesRarity.isEmpty()) {
            HarvestCraft.log.debug("no fruit available for biome: " + biome.getRegistryName().toString() + " with rarity < " + rarity + ".");
            return;
        }
        int index = random.nextInt(fruitTreesRarity.size());
        if (index < 0) {
            HarvestCraft.log.debug("is < 0");
            return;
        }
        TreeGenerationConfiguration fruitTree = fruitTreesRarity.get(index);
        if (fruitTree == null) {
            HarvestCraft.log.debug("fruit tree is null");
            return;
        }
        this.generateFruitTree(world, random, fruitTree.getFruit(), x, z);
    }

    private void generateFruitTree(World world, Random random, String fruitName, int x, int z) {
        BlockPamSapling sapling = FruitRegistry.getSapling(fruitName);
        if (sapling != null) {
            sapling.worldGenTree(world, random, x, z);
        }
    }
}

