/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.tileentities;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.CropRegistry;
import com.pam.harvestcraft.config.ConfigHandler;
import com.pam.harvestcraft.item.ItemRegistry;
import com.pam.harvestcraft.tileentities.ShippingBinData;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ShippingBinItems {
    private static final ArrayList<ShippingBinData> items = new ArrayList();

    private static void registerItems(ShippingBinData data) {
        items.add(data);
    }

    public static ShippingBinData getData(int i) {
        return items.get(i);
    }

    public static int getSize() {
        return items.size();
    }

    public static void registerItems() {
        if (HarvestCraft.config.shippingbinbuyCrops) {
            ShippingBinItems.registerCrops();
        }
        if (HarvestCraft.config.shippingbinbuyFish) {
            ShippingBinItems.registerFish();
        }
        if (HarvestCraft.config.shippingbinbuyMeat) {
            ShippingBinItems.registerMeat();
        }
        if (HarvestCraft.config.shippingbinbuyBees) {
            ShippingBinItems.registerBees();
        }
    }

    private static void registerCrops() {
        ItemStack currency = ShippingBinItems.getCurrency(HarvestCraft.config.marketcurrencySeeds, CurrencyType.SEEDS);
        for (Item item : CropRegistry.getFoods().values()) {
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(item), HarvestCraft.config.shippingbincropPrice));
        }
        if (ConfigHandler.shippingbinenablevanillaMCCrops) {
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151034_e), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151015_O), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Blocks.field_150423_aK), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151127_ba), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_185164_cV), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151172_bF), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151174_bG), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151100_aR, 1, 3), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151075_bm), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_185161_cS), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151120_aE), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack((Block)Blocks.field_150434_aF), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack((Block)Blocks.field_150338_P), HarvestCraft.config.shippingbincropPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack((Block)Blocks.field_150337_Q), HarvestCraft.config.shippingbincropPrice));
        }
    }

    private static void registerFish() {
        ItemStack currency = ShippingBinItems.getCurrency(HarvestCraft.config.marketcurrencyFish, CurrencyType.FISH);
        if (ConfigHandler.shippingbinenablevanillaMCFish) {
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151115_aP, 1, -1), HarvestCraft.config.shippingbinfishPrice));
        }
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.anchovyrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.bassrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.carprawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.catfishrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.charrrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.clamrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.crabrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.crayfishrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.eelrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.frograwItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.grouperrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.herringrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.jellyfishrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.mudfishrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.octopusrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.perchrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.scalloprawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.shrimprawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.snailrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.snapperrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.tilapiarawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.troutrawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.tunarawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.turtlerawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.walleyerawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.sardinerawItem), HarvestCraft.config.shippingbinfishPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.rawtofishItem), HarvestCraft.config.shippingbinfishPrice));
    }

    private static void registerMeat() {
        ItemStack currency = ShippingBinItems.getCurrency(HarvestCraft.config.marketcurrencyMeat, CurrencyType.MEAT);
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.duckrawItem), HarvestCraft.config.shippingbinmeatPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.turkeyrawItem), HarvestCraft.config.shippingbinmeatPrice));
        ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.venisonrawItem), HarvestCraft.config.shippingbinmeatPrice));
        if (ConfigHandler.shippingbinenablevanillaMCMeat) {
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151082_bd), HarvestCraft.config.shippingbinmeatPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151147_al), HarvestCraft.config.shippingbinmeatPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_179561_bm), HarvestCraft.config.shippingbinmeatPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_179558_bo), HarvestCraft.config.shippingbinmeatPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151076_bf), HarvestCraft.config.shippingbinmeatPrice));
        }
        if (ConfigHandler.shippingbinenablevanillaMCEgg) {
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151110_aK), HarvestCraft.config.shippingbinmeatPrice));
        }
        if (ConfigHandler.shippingbinenablevanillaMCMonsterParts) {
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151078_bh), HarvestCraft.config.shippingbinmeatPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151070_bp), HarvestCraft.config.shippingbinmeatPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(Items.field_151103_aS), HarvestCraft.config.shippingbinmeatPrice));
        }
    }

    private static void registerBees() {
        ItemStack currency = ShippingBinItems.getCurrency(HarvestCraft.config.marketcurrencyBees, CurrencyType.BEES);
        if (ConfigHandler.shippingbinenablevanillaMCBees) {
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.waxcombItem), HarvestCraft.config.shippingbinbeesPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.honeycombItem), HarvestCraft.config.shippingbinbeesPrice));
            ShippingBinItems.registerItems(new ShippingBinData(currency, new ItemStack(ItemRegistry.grubItem), HarvestCraft.config.shippingbinbeesPrice));
        }
    }

    private static ItemStack getCurrency(int config, CurrencyType currencyType) {
        switch (config) {
            case 1: {
                return new ItemStack(Items.field_151045_i);
            }
            case 2: {
                return new ItemStack(Items.field_151043_k);
            }
            case 3: {
                return new ItemStack(Items.field_151074_bl);
            }
            case 4: {
                return new ItemStack(Items.field_151042_j);
            }
            case 5: {
                if (currencyType.equals((Object)CurrencyType.ANIMAL)) {
                    return new ItemStack(Items.field_151110_aK);
                }
                if (currencyType.equals((Object)CurrencyType.SEEDS)) {
                    return new ItemStack(Items.field_151014_N);
                }
                if (currencyType.equals((Object)CurrencyType.SAPLING)) {
                    return new ItemStack(Blocks.field_150345_g);
                }
                return null;
            }
            case 6: {
                return new ItemStack(Items.field_151034_e);
            }
            case 7: {
                return new ItemStack(Items.field_151100_aR);
            }
            case 8: {
                return new ItemStack(ItemRegistry.garliccoinItem);
            }
        }
        return new ItemStack(Items.field_151166_bC);
    }

    private static enum CurrencyType {
        DEFAULT,
        SEEDS,
        SAPLING,
        ANIMAL,
        FISH,
        MEAT,
        BEES;

    }
}

