/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import com.fantasticsource.tools.ReflectionTool;
import java.util.Collection;
import java.util.Map;
import mezz.jei.Internal;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.search.GeneralizedSuffixTree;
import mezz.jei.search.PrefixInfo;
import mezz.jei.search.PrefixedSearchable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ThreadedHEITooltipReloader {
    protected static volatile ThreadedData QUEUED_DATA = null;
    protected static volatile ThreadedData PROCESSED_DATA = null;
    protected static volatile boolean STOP = false;
    protected static Thread thread = null;
    protected static final Runnable runnable = () -> {
        ThreadedData workingData = QUEUED_DATA;
        QUEUED_DATA = null;
        for (int i = 0; i < workingData.elements.length; ++i) {
            IIngredientListElement element = workingData.elements[i];
            Collection<String> strings = workingData.stringsGetter.getStrings(element);
            for (String string : strings) {
                workingData.tree.put(string, element);
                if (!STOP) continue;
                break;
            }
            if (STOP) break;
        }
        if (!STOP) {
            PROCESSED_DATA = workingData;
        } else {
            STOP = false;
        }
    };
    protected final PrefixedSearchable tooltipSearchable;
    protected final int elementCount;

    public ThreadedHEITooltipReloader(Map<PrefixInfo, PrefixedSearchable> prefixedSearchables, NonNullList<IIngredientListElement> elements) {
        this.tooltipSearchable = ThreadedHEITooltipReloader.getTooltipSearchable(prefixedSearchables);
        this.elementCount = elements.size();
        MinecraftForge.EVENT_BUS.register((Object)this);
        QUEUED_DATA = new ThreadedData((PrefixInfo.IStringsGetter)ReflectionTool.get(PrefixInfo.class, (String)"stringsGetter", (Object)this.tooltipSearchable.prefixInfo), elements);
        if (thread != null && thread.isAlive()) {
            STOP = true;
            while (thread.isAlive()) {
            }
            System.out.println("Cancelled reloading HEI tooltips on background thread");
        }
        thread = new Thread(runnable);
        thread.setName("Set Bonus HEI Tooltip Reload");
        thread.start();
        System.out.println("Started reloading HEI tooltips on background thread");
    }

    protected static PrefixedSearchable getTooltipSearchable(Map<PrefixInfo, PrefixedSearchable> prefixedSearchables) {
        for (Map.Entry<PrefixInfo, PrefixedSearchable> entry : prefixedSearchables.entrySet()) {
            if (entry.getKey().getPrefix() != '#') continue;
            return entry.getValue();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && PROCESSED_DATA != null) {
            ThreadedData data = PROCESSED_DATA;
            PROCESSED_DATA = null;
            ReflectionTool.set(PrefixedSearchable.class, (String)"searchStorage", (Object)this.tooltipSearchable, (Object)data.tree);
            IngredientFilter ingredientFilter = Internal.getIngredientFilter();
            ingredientFilter.invalidateCache();
            ReflectionTool.set(IngredientFilter.class, (String)"filterCached", (Object)ingredientFilter, null);
            Internal.getRuntime().getIngredientListOverlay().updateLayout(true);
            System.out.println("Finished reloading HEI tooltips on background thread");
        }
    }

    public static boolean needsReload(Map<PrefixInfo, PrefixedSearchable> prefixedSearchables) {
        for (Map.Entry<PrefixInfo, PrefixedSearchable> entry : prefixedSearchables.entrySet()) {
            if (entry.getValue().getMode() == Config.SearchMode.DISABLED || entry.getKey().getPrefix() != '#') continue;
            return true;
        }
        return false;
    }

    public static class ThreadedData {
        PrefixInfo.IStringsGetter stringsGetter;
        GeneralizedSuffixTree tree;
        IIngredientListElement[] elements;

        ThreadedData(PrefixInfo.IStringsGetter stringsGetter, NonNullList<IIngredientListElement> elements) {
            this.stringsGetter = stringsGetter;
            this.tree = new GeneralizedSuffixTree();
            this.elements = (IIngredientListElement[])elements.toArray((Object[])new IIngredientListElement[0]);
        }
    }
}

