/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.fantasticsource.tools.ReflectionTool;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import java.util.Collection;
import java.util.Map;
import mezz.jei.Internal;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.PrefixedSearchTree;
import mezz.jei.suffixtree.CombinedSearchTrees;
import mezz.jei.suffixtree.GeneralizedSuffixTree;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ThreadedJEITooltipReloader {
    protected static volatile ThreadedData QUEUED_DATA = null;
    protected static volatile ThreadedData PROCESSED_DATA = null;
    protected static volatile boolean STOP = false;
    protected static Thread thread = null;
    protected static final Runnable runnable = () -> {
        ThreadedData workingData = QUEUED_DATA;
        QUEUED_DATA = null;
        for (int i = 0; i < workingData.elements.length; ++i) {
            Collection strings = workingData.stringsGetter.getStrings(workingData.elements[i]);
            if (strings.isEmpty()) {
                workingData.tree.put("", i);
            } else {
                for (String string : strings) {
                    workingData.tree.put(string, i);
                    if (!STOP) continue;
                    break;
                }
            }
            if (STOP) break;
        }
        if (!STOP) {
            PROCESSED_DATA = workingData;
        } else {
            STOP = false;
        }
    };
    protected final PrefixedSearchTree tooltipTree;
    protected final int elementCount;

    public ThreadedJEITooltipReloader(Char2ObjectMap prefixedSearchTrees, NonNullList<IIngredientListElement> elementList) {
        this.tooltipTree = (PrefixedSearchTree)prefixedSearchTrees.get('#');
        this.elementCount = elementList.size();
        MinecraftForge.EVENT_BUS.register((Object)this);
        QUEUED_DATA = new ThreadedData(this.tooltipTree.getStringsGetter(), elementList);
        if (thread != null && thread.isAlive()) {
            STOP = true;
            while (thread.isAlive()) {
            }
            System.out.println("Cancelled reloading JEI tooltips on background thread");
        }
        thread = new Thread(runnable);
        thread.setName("Set Bonus JEI Tooltip Reload");
        thread.start();
        System.out.println("Started reloading JEI tooltips on background thread");
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && PROCESSED_DATA != null) {
            ThreadedData data = PROCESSED_DATA;
            PROCESSED_DATA = null;
            if (data.elements.length == this.elementCount) {
                ReflectionTool.set(PrefixedSearchTree.class, (String)"tree", (Object)this.tooltipTree, (Object)data.tree);
                IngredientFilter ingredientFilter = Internal.getIngredientFilter();
                Object searchTree = ReflectionTool.get(IngredientFilter.class, (String)"searchTree", (Object)ingredientFilter);
                Char2ObjectMap trees = (Char2ObjectMap)ReflectionTool.get(IngredientFilter.class, (String)"prefixedSearchTrees", (Object)ingredientFilter);
                CombinedSearchTrees combinedSearchTrees = (CombinedSearchTrees)ReflectionTool.invoke(IngredientFilter.class, (String)"buildCombinedSearchTrees", (Object)ingredientFilter, (Object[])new Object[]{searchTree, trees.values()});
                ReflectionTool.set(IngredientFilter.class, (String)"combinedSearchTrees", (Object)ingredientFilter, (Object)combinedSearchTrees);
                ReflectionTool.set(IngredientFilter.class, (String)"filterCached", (Object)ingredientFilter, null);
                Internal.getRuntime().getIngredientListOverlay().updateLayout(true);
            }
            System.out.println("Finished reloading JEI tooltips on background thread");
        }
    }

    public static boolean needsReload(Char2ObjectMap prefixedSearchTrees) {
        for (Map.Entry entry : prefixedSearchTrees.entrySet()) {
            if (((PrefixedSearchTree)entry.getValue()).getMode() == Config.SearchMode.DISABLED || ((Character)entry.getKey()).charValue() != '#') continue;
            return true;
        }
        return false;
    }

    public static class ThreadedData {
        PrefixedSearchTree.IStringsGetter stringsGetter;
        GeneralizedSuffixTree tree;
        IIngredientListElement[] elements;

        ThreadedData(PrefixedSearchTree.IStringsGetter stringsGetter, NonNullList<IIngredientListElement> elementList) {
            this.stringsGetter = stringsGetter;
            this.tree = new GeneralizedSuffixTree();
            this.elements = (IIngredientListElement[])elementList.toArray((Object[])new IIngredientListElement[0]);
        }
    }
}

